/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class Deb2Extension
extends SmfData {
    public static final int DEB2XOSM = 128;
    public static final int DEB2XNLM = 64;
    public static final int DEB2XTCO = 32;
    public static final int DEB2XIBC = 16;
    public static final int DEB2XNL1 = 8;
    public static final int DEB2XVLL = 4;
    public static final int DEB2XABC = 2;
    public static final int DEB2XECU = 1;
    public static final int DEB2X32M = 128;
    public static final int DEB2XBTM = 64;
    public static final int DEB2XUSS = 32;
    public static final int DEB2XEXV = 16;
    public static final int DEB2XSCA = 8;
    public static final int DEB2BTMS = 4;
    public static final int DEB2XEMV = 2;
    public static final int DEB2X8WN = 1;
    public static final int DEB2XEXT = 128;
    public static final int DEB2XOPO = 64;
    public static final int DEB2XINO = 32;
    public static final int DEB2XEPS = 16;
    public static final int DEB2XSCS = 128;
    public static final int DEB2XPSC = 64;
    public static final int DEB2XEF1 = 32;
    public static final int DEB2XUPF = 16;
    public static final int DEB2XEXCP = 8;
    public static final int DEB2XMSDN = 4;
    public static final int DEB2XTRCE = 2;
    public static final int DEB2XSBS = 1;
    public static final int DEB2XIBM = 128;
    public static final int DEB2XOUT = 64;
    public static final int DEB2XMOD = 32;
    public static final int DEB2XUDF = 16;
    public static final int DEB2XTDF = 8;
    public static final int DEB2XIGN = 4;
    public static final int DEB2XEEF = 32;
    public static final int DEB2XE1M = 16;
    public static final int DEB2XE1I = 8;
    public static final int DEB2XE2M = 4;
    public static final int DEB2XE2I = 2;
    public static final int DEB2XEE3 = 1;
    public static final int DEB2XEF2 = 128;
    public static final int DEB2XENC = 64;
    public static final int DEB2XMNW = 32;
    public static final int DEB2XDEQ = 16;
    public static final int DEB2XEF3 = 8;
    public static final int DEB2XEE4 = 4;
    public static final int DEB2XEEG = 2;
    public static final int DEB2XCDT = 1;
    public static final int DEB2XEEX = 128;
    public static final int DEB2XDSO = 64;
    public static final int DEB2XFRE = 32;
    public static final int DEB2XKEY = 16;
    public static final int DEB2XEID = 8;
    public static final int DEB2XMIN = 4;
    public static final int DEB2XNDE = 2;
    public static final int DEB2XRBL = 1;
    public static final int DEB2XVLC = 128;
    public static final int DEB2XPLR = 64;
    public static final int DEB2XFCC = 32;
    public static final int DEB2XLVL = 16;
    public static final int DEB2XCMPNA = 0;
    public static final int DEB2XCMPGEN = 1;
    public static final int DEB2XCMPTLRD = 2;
    public static final int DEB2XCMPZEDC = 3;
    public static final int DEB2XDBYP = 128;
    public static final int DEB2XJBYP = 64;
    public static final int DEB2XAUTH = 32;
    public static final int DEB2XBYP = 16;
    public static final int DEB2XBPNOTPDS = 8;
    public static final int DEB2XEXTDFAIL = 4;
    public static final int DEB2XDSENCRYPTOK = 2;
    public static final int DEB2XDSENCREJ = 1;
    public static final int DEB2XLEN = 239;

    private Deb2Extension(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String deb2xtnn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public int deb2xlgh() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int deb2xsgl() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public String deb2xsgn() {
        if (this.data.length >= 12 + this.deb2xsgl()) {
            return Util.ConvertEbcdic(this.data, 12, this.deb2xsgl());
        }
        return null;
    }

    public int deb2xmcl() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public String deb2xmcn() {
        if (this.data.length >= 44 + this.deb2xmcl()) {
            return Util.ConvertEbcdic(this.data, 44, this.deb2xmcl());
        }
        return null;
    }

    public int deb2xscl() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public String deb2xscn() {
        if (this.data.length >= 76 + this.deb2xscl()) {
            return Util.ConvertEbcdic(this.data, 76, this.deb2xscl());
        }
        return null;
    }

    public int deb2xdcl() {
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public String deb2xdcn() {
        if (this.data.length >= 108 + this.deb2xdcl()) {
            return Util.ConvertEbcdic(this.data, 108, this.deb2xdcl());
        }
        return null;
    }

    public int deb2xfg1() {
        return Util.ConvertUnsignedBinary1(this.data, 138);
    }

    public boolean deb2xosm() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 128);
    }

    public boolean deb2xnlm() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 64);
    }

    public boolean deb2xtco() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 32);
    }

    public boolean deb2xibc() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 16);
    }

    public boolean deb2xnl1() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 8);
    }

    public boolean deb2xvll() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 4);
    }

    public boolean deb2xabc() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 2);
    }

    public boolean deb2xecu() {
        return Util.ConvertFlag(this.data, this.deb2xfg1(), 1);
    }

    public int deb2xuof() {
        return Util.ConvertUnsignedBinary1(this.data, 139);
    }

    public int deb2xlsq() {
        return Util.ConvertUnsignedBinary2(this.data, 140);
    }

    public int deb2xalv() {
        return Util.ConvertUnsignedBinary1(this.data, 142);
    }

    public int deb2xfg2() {
        return Util.ConvertUnsignedBinary1(this.data, 143);
    }

    public boolean deb2x32m() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 128);
    }

    public boolean deb2xbtm() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 64);
    }

    public boolean deb2xuss() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 32);
    }

    public boolean deb2xexv() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 16);
    }

    public boolean deb2xsca() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 8);
    }

    public boolean deb2btms() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 4);
    }

    public boolean deb2xemv() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 2);
    }

    public boolean deb2x8wn() {
        return Util.ConvertFlag(this.data, this.deb2xfg2(), 1);
    }

    public long deb2xtim() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public int deb2xexc() {
        return Util.ConvertUnsignedBinary1(this.data, 148);
    }

    public int deb2xedi() {
        return Util.ConvertUnsignedBinary1(this.data, 149);
    }

    public boolean deb2xext() {
        return Util.ConvertFlag(this.data, this.deb2xedi(), 128);
    }

    public boolean deb2xopo() {
        return Util.ConvertFlag(this.data, this.deb2xedi(), 64);
    }

    public boolean deb2xino() {
        return Util.ConvertFlag(this.data, this.deb2xedi(), 32);
    }

    public boolean deb2xeps() {
        return Util.ConvertFlag(this.data, this.deb2xedi(), 16);
    }

    public int deb2xfg3() {
        return Util.ConvertUnsignedBinary1(this.data, 150);
    }

    public boolean deb2xscs() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 128);
    }

    public boolean deb2xpsc() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 64);
    }

    public boolean deb2xef1() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 32);
    }

    public boolean deb2xupf() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 16);
    }

    public boolean deb2xexcp() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 8);
    }

    public boolean deb2xmsdn() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 4);
    }

    public boolean deb2xtrce() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 2);
    }

    public boolean deb2xsbs() {
        return Util.ConvertFlag(this.data, this.deb2xfg3(), 1);
    }

    public int deb2xcfg() {
        return Util.ConvertUnsignedBinary1(this.data, 151);
    }

    public boolean deb2xibm() {
        return Util.ConvertFlag(this.data, this.deb2xcfg(), 128);
    }

    public boolean deb2xout() {
        return Util.ConvertFlag(this.data, this.deb2xcfg(), 64);
    }

    public boolean deb2xmod() {
        return Util.ConvertFlag(this.data, this.deb2xcfg(), 32);
    }

    public boolean deb2xudf() {
        return Util.ConvertFlag(this.data, this.deb2xcfg(), 16);
    }

    public boolean deb2xtdf() {
        return Util.ConvertFlag(this.data, this.deb2xcfg(), 8);
    }

    public boolean deb2xign() {
        return Util.ConvertFlag(this.data, this.deb2xcfg(), 4);
    }

    public long deb2xusr() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long deb2xtpe() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long deb2xlbl() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long deb2xsdc() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long deb2xtbl() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long deb2xtcb() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public int deb2xsgt() {
        return Util.ConvertUnsignedBinary1(this.data, 176);
    }

    public int deb2xpar() {
        return Util.ConvertUnsignedBinary1(this.data, 177);
    }

    public int deb2xfg4() {
        return Util.ConvertUnsignedBinary1(this.data, 178);
    }

    public boolean deb2xeef() {
        return Util.ConvertFlag(this.data, this.deb2xfg4(), 32);
    }

    public boolean deb2xe1m() {
        return Util.ConvertFlag(this.data, this.deb2xfg4(), 16);
    }

    public boolean deb2xe1i() {
        return Util.ConvertFlag(this.data, this.deb2xfg4(), 8);
    }

    public boolean deb2xe2m() {
        return Util.ConvertFlag(this.data, this.deb2xfg4(), 4);
    }

    public boolean deb2xe2i() {
        return Util.ConvertFlag(this.data, this.deb2xfg4(), 2);
    }

    public boolean deb2xee3() {
        return Util.ConvertFlag(this.data, this.deb2xfg4(), 1);
    }

    public int deb2xfg5() {
        return Util.ConvertUnsignedBinary1(this.data, 179);
    }

    public boolean deb2xef2() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 128);
    }

    public boolean deb2xenc() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 64);
    }

    public boolean deb2xmnw() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 32);
    }

    public boolean deb2xdeq() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 16);
    }

    public boolean deb2xef3() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 8);
    }

    public boolean deb2xee4() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 4);
    }

    public boolean deb2xeeg() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 2);
    }

    public boolean deb2xcdt() {
        return Util.ConvertFlag(this.data, this.deb2xfg5(), 1);
    }

    public long deb2xsbl() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long deb2xstv() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long deb2xnxv() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long deb2xvln() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long deb2xmxv() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public ZonedDateTime deb2xdid() {
        return Util.Binary8xStckTime(this.data, 200);
    }

    public BigInteger deb2xdidRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 200);
    }

    public int deb2xlk1() {
        return Util.ConvertUnsignedBinary1(this.data, 208);
    }

    public int deb2xlk2() {
        return Util.ConvertUnsignedBinary1(this.data, 209);
    }

    public int deb2xfg6() {
        return Util.ConvertUnsignedBinary1(this.data, 210);
    }

    public boolean deb2xeex() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 128);
    }

    public boolean deb2xdso() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 64);
    }

    public boolean deb2xfre() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 32);
    }

    public boolean deb2xkey() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 16);
    }

    public boolean deb2xeid() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 8);
    }

    public boolean deb2xmin() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 4);
    }

    public boolean deb2xnde() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 2);
    }

    public boolean deb2xrbl() {
        return Util.ConvertFlag(this.data, this.deb2xfg6(), 1);
    }

    public int deb2xfg7() {
        return Util.ConvertUnsignedBinary1(this.data, 211);
    }

    public boolean deb2xvlc() {
        return Util.ConvertFlag(this.data, this.deb2xfg7(), 128);
    }

    public boolean deb2xplr() {
        return Util.ConvertFlag(this.data, this.deb2xfg7(), 64);
    }

    public boolean deb2xfcc() {
        return Util.ConvertFlag(this.data, this.deb2xfg7(), 32);
    }

    public boolean deb2xlvl() {
        return Util.ConvertFlag(this.data, this.deb2xfg7(), 16);
    }

    public int deb2xcmptype() {
        return Util.ConvertUnsignedBinary1(this.data, 211);
    }

    public boolean deb2xcmpna() {
        return Util.ConvertEquateValue(this.data, this.deb2xcmptype(), 0, 15);
    }

    public boolean deb2xcmpgen() {
        return Util.ConvertEquateValue(this.data, this.deb2xcmptype(), 1, 15);
    }

    public boolean deb2xcmptlrd() {
        return Util.ConvertEquateValue(this.data, this.deb2xcmptype(), 2, 15);
    }

    public boolean deb2xcmpzedc() {
        return Util.ConvertEquateValue(this.data, this.deb2xcmptype(), 3, 15);
    }

    public long deb2xket() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long deb2xdxp() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public int deb2xdsv() {
        return Util.ConvertUnsignedBinary1(this.data, 220);
    }

    public int deb2xfg8() {
        return Util.ConvertUnsignedBinary1(this.data, 221);
    }

    public boolean deb2xdbyp() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 128);
    }

    public boolean deb2xjbyp() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 64);
    }

    public boolean deb2xauth() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 32);
    }

    public boolean deb2xbyp() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 16);
    }

    public boolean deb2xbpnotpds() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 8);
    }

    public boolean deb2xextdfail() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 4);
    }

    public boolean deb2xdsencryptok() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 2);
    }

    public boolean deb2xdsencrej() {
        return Util.ConvertFlag(this.data, this.deb2xfg8(), 1);
    }

    public long deb2xtbx() {
        return Util.ConvertUnsignedBinary8(this.data, 224);
    }

    public BigInteger deb2xtbxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 224);
    }

    public String deb2xven() {
        return Util.ConvertEbcdic(this.data, 232, 7);
    }

    public static Deb2Extension create(byte[] Data2, int offset, int length) {
        return new Deb2Extension(Data2, offset, length);
    }

    static enum Field {
        deb2xtnn(0, 8),
        deb2xlgh(8, 2),
        deb2xsgl(10, 2),
        deb2xsgn(12, 0),
        deb2xmcl(42, 2),
        deb2xmcn(44, 0),
        deb2xscl(74, 2),
        deb2xscn(76, 0),
        deb2xdcl(106, 2),
        deb2xdcn(108, 0),
        deb2xfg1(138, 1),
        deb2xuof(139, 1),
        deb2xlsq(140, 2),
        deb2xalv(142, 1),
        deb2xfg2(143, 1),
        deb2xtim(144, 4),
        deb2xexc(148, 1),
        deb2xedi(149, 1),
        deb2xfg3(150, 1),
        deb2xcfg(151, 1),
        deb2xusr(152, 4),
        deb2xtpe(156, 4),
        deb2xlbl(160, 4),
        deb2xsdc(164, 4),
        deb2xtbl(168, 4),
        deb2xtcb(172, 4),
        deb2xsgt(176, 1),
        deb2xpar(177, 1),
        deb2xfg4(178, 1),
        deb2xfg5(179, 1),
        deb2xsbl(180, 4),
        deb2xstv(184, 4),
        deb2xnxv(188, 4),
        deb2xvln(192, 4),
        deb2xmxv(196, 4),
        deb2xdid(200, 8),
        deb2xlk1(208, 1),
        deb2xlk2(209, 1),
        deb2xfg6(210, 1),
        deb2xfg7(211, 1),
        deb2xcmptype(211, 1),
        deb2xket(212, 4),
        deb2xdxp(216, 4),
        deb2xdsv(220, 1),
        deb2xfg8(221, 1),
        deb2xtbx(224, 8),
        deb2xven(232, 7);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

