/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.security;

import java.util.HashMap;
import java.util.Map;

public enum PoeClass {
    TERMINAL(1),
    CONSOLE(2),
    JESINPUT(3),
    APPCPORT(4),
    SERVAUTH(5),
    NOT_DEFINED(-16);

    private static Map<Integer, PoeClass> valueMap;
    private final int poeclass;

    private PoeClass(int poeclass) {
        this.poeclass = poeclass;
    }

    public static PoeClass from(int value) {
        PoeClass result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int poeclass() {
        return this.poeclass;
    }

    static {
        valueMap = new HashMap<Integer, PoeClass>();
        for (PoeClass x : PoeClass.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.poeclass, x);
        }
    }
}

