/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.security;

import java.util.HashMap;
import java.util.Map;

public enum SessionType {
    SYSTEM_ADDRESS_SPACE(1),
    COMMAND(2),
    CONSOLE(3),
    STARTED_PROCEDURE(4),
    MOUNT(5),
    TSO(6),
    INTERNAL_READER_BATCH(7),
    EXECUTION_BATCH_MONITOR(8),
    RJE(9),
    NJE(10),
    VERIFYX_UNKNOWN_USER(11),
    EXTERNAL_READER_BATCH(12),
    RJE_BATCH(13),
    NJE_BATCH(14),
    NJE_SYSOUT(15),
    EXTERNAL_XBM(16),
    RJE_XBM(17),
    NJE_XBM(18),
    APPCTP(19),
    OMVSSRV(20),
    IPLOOKUP(21),
    NOT_DEFINED(-16);

    private static Map<Integer, SessionType> valueMap;
    private final int sessiontype;

    private SessionType(int sessiontype) {
        this.sessiontype = sessiontype;
    }

    public static SessionType from(int value) {
        SessionType result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int sessiontype() {
        return this.sessiontype;
    }

    static {
        valueMap = new HashMap<Integer, SessionType>();
        for (SessionType x : SessionType.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.sessiontype, x);
        }
    }
}

