/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class ConnectionInitiation
extends SmfData {
    private ConnectionInitiation(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf119apTiRName() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long smf119apTiConnID() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public String smf119apTiSubTask() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public InetAddress smf119apTiRip() {
        return Util.ConvertInetV6Address(this.data, 20);
    }

    public BigInteger smf119apTiRipRawValue() {
        return Util.ConvertBigInteger(this.data, 20, 16);
    }

    public int smf119apTIRIPFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public InetAddress smf119apTiLip() {
        return Util.ConvertInetV6Address(this.data, 36);
    }

    public BigInteger smf119apTiLipRawValue() {
        return Util.ConvertBigInteger(this.data, 36, 16);
    }

    public int smf119apTiLipFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public int smf119apTiRPort() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf119apTiLPort() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public LocalTime smf119apTiTime() {
        return Util.Binary4x100STime(this.data, 56);
    }

    public long smf119apTiTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public LocalDate smf119apTiDate() {
        return Util.SMFDate(this.data, 60);
    }

    public int smf119apTiDateRawValue() {
        return Util.ConvertPacked4(this.data, 60);
    }

    public ZonedDateTime smf119apTiStck() {
        return Util.Binary8xStckTime(this.data, 64);
    }

    public BigInteger smf119apTiStckRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public static ConnectionInitiation create(byte[] Data2, int offset, int length) {
        return new ConnectionInitiation(Data2, offset, length);
    }

    static enum Field {
        smf119apTiRName(0, 8),
        smf119apTiConnID(8, 4),
        smf119apTiSubTask(16, 4),
        smf119apTiRip(20, 16),
        smf119apTIRIPFmt(30, 2),
        smf119apTiLip(36, 16),
        smf119apTiLipFmt(46, 2),
        smf119apTiRPort(52, 2),
        smf119apTiLPort(54, 2),
        smf119apTiTime(56, 4),
        smf119apTiDate(60, 4),
        smf119apTiStck(64, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

