/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalTime;

public final class TN3270SNASessionInitiation
extends SmfData {
    private TN3270SNASessionInitiation(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf119tnNiLu() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf119tnNiAppl() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long smf119tnNiLDev() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public InetAddress smf119tnNiRip() {
        return Util.ConvertInetV6Address(this.data, 20);
    }

    public BigInteger smf119tnNiRipRawValue() {
        return Util.ConvertBigInteger(this.data, 20, 16);
    }

    public int smf119tnNiRipRFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public InetAddress smf119tnNiRipIPv4() {
        return Util.ConvertInetV4Address(this.data, 32);
    }

    public BigInteger smf119tnNiRipIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 32, 4);
    }

    public InetAddress smf119tnNiLip() {
        return Util.ConvertInetV6Address(this.data, 36);
    }

    public BigInteger smf119tnNiLipRawValue() {
        return Util.ConvertBigInteger(this.data, 36, 16);
    }

    public int smf119tnNiLipRFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public InetAddress smf119tnNiLipIPv4() {
        return Util.ConvertInetV4Address(this.data, 48);
    }

    public BigInteger smf119tnNiLipIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 48, 4);
    }

    public int smf119tnNiRPort() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf119tnNiLPort() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public LocalTime smf119tnNiTime() {
        return Util.Binary4x100STime(this.data, 56);
    }

    public long smf119tnNiTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public LocalDate smf119tnNiDate() {
        return Util.SMFDate(this.data, 60);
    }

    public int smf119tnNiDateRawValue() {
        return Util.ConvertPacked4(this.data, 60);
    }

    public static TN3270SNASessionInitiation create(byte[] Data2, int offset, int length) {
        return new TN3270SNASessionInitiation(Data2, offset, length);
    }

    static enum Field {
        smf119tnNiLu(0, 8),
        smf119tnNiAppl(8, 8),
        smf119tnNiLDev(16, 4),
        smf119tnNiRip(20, 16),
        smf119tnNiRipRFmt(30, 2),
        smf119tnNiRipIPv4(32, 4),
        smf119tnNiLip(36, 16),
        smf119tnNiLipRFmt(46, 2),
        smf119tnNiLipIPv4(48, 4),
        smf119tnNiRPort(52, 2),
        smf119tnNiLPort(54, 2),
        smf119tnNiTime(56, 4),
        smf119tnNiDate(60, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

