/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.CertDigestAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.CertEncryptionMethod;
import com.blackhillsoftware.smf.smf119.zert.EncryptionAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.IPSecAuthMethod;
import com.blackhillsoftware.smf.smf119.zert.IPSecAuthProto;
import com.blackhillsoftware.smf.smf119.zert.IPSecDHGroup;
import com.blackhillsoftware.smf.smf119.zert.IPSecEncapsulationMode;
import com.blackhillsoftware.smf.smf119.zert.IPSecPseudoRandFunc;
import com.blackhillsoftware.smf.smf119.zert.KeyType;
import com.blackhillsoftware.smf.smf119.zert.MessageAuthAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.SignatureMethod;
import com.blackhillsoftware.smf.smf119.zert.TimeType;
import com.blackhillsoftware.smf.smf119.zert.TunnelState;
import com.blackhillsoftware.smf.smf119.zert.TunnelType;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class ZertDetailIPSecSection
extends SmfData {
    private boolean ipV6 = false;
    public static final int SMF119SC_IPSec_IPv6 = 128;
    public static final int SMF119SC_IPSec_FIPSMode = 64;

    private ZertDetailIPSecSection(byte[] Data2, int offset, int length, boolean ipV6) {
        super(Data2, offset, length);
        this.ipV6 = ipV6;
    }

    public long smf119scIPSecIKETunID() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int smf119scIPSecIKEMajVer() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf119scIPSecIKEMinVer() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public String smf119scIPSecIKETunKeyExchRule() {
        return Util.ConvertEbcdic(this.data, 8, 48);
    }

    public InetAddress smf119scIPSecIKETunLclEndpt() {
        return this.ipV6 ? this.smf119scIPSecIKETunLclEpIPv6() : this.smf119scIPSecIKETunLclEpIPv4();
    }

    public BigInteger smf119scIPSecIKETunLclEndptRawValue() {
        return Util.ConvertBigInteger(this.data, 56, 16);
    }

    private InetAddress smf119scIPSecIKETunLclEpIPv4() {
        return Util.ConvertInetV4Address(this.data, 56);
    }

    private BigInteger smf119scIPSecIKETunLclEpIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 56, 4);
    }

    private InetAddress smf119scIPSecIKETunLclEpIPv6() {
        return Util.ConvertInetV6Address(this.data, 56);
    }

    private BigInteger smf119scIPSecIKETunLclEpIPRawValue() {
        return Util.ConvertBigInteger(this.data, 56, 16);
    }

    public InetAddress smf119scIPSecIKETunRmtEndpt() {
        return this.ipV6 ? this.smf119scIPSecIKETunRmtEpIPv6() : this.smf119scIPSecIKETunRmtEpIPv4();
    }

    public BigInteger smf119scIPSecIKETunRmtEndptRawValue() {
        return Util.ConvertBigInteger(this.data, 72, 16);
    }

    private InetAddress smf119scIPSecIKETunRmtEpIPv4() {
        return Util.ConvertInetV4Address(this.data, 72);
    }

    private BigInteger smf119scIPSecIKETunRmtEpIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 72, 4);
    }

    private InetAddress smf119scIPSecIKETunRmtEpIPv6() {
        return Util.ConvertInetV6Address(this.data, 72);
    }

    private BigInteger smf119scIPSecIKETunRmtEpIPRawValue() {
        return Util.ConvertBigInteger(this.data, 72, 16);
    }

    public IPSecAuthMethod smf119scIPSecIKETunLclAuthMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 88);
        return IPSecAuthMethod.from(value);
    }

    public int smf119scIPSecIKETunLclAuthMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public IPSecAuthMethod smf119scIPSecIKETunRmtAuthMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 90);
        return IPSecAuthMethod.from(value);
    }

    public int smf119scIPSecIKETunRmtAuthMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public MessageAuthAlgorithm smf119scIPSecIKETunAuthAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 92);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119scIPSecIKETunAuthAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 92);
    }

    public EncryptionAlgorithm smf119scIPSecIKETunEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 94);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119scIPSecIKETunEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 94);
    }

    public IPSecDHGroup smf119scIPSecIKETunDHGroup() {
        int value = Util.ConvertUnsignedBinary2(this.data, 96);
        return IPSecDHGroup.from(value);
    }

    public int smf119scIPSecIKETunDHGroupRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public IPSecPseudoRandFunc smf119scIPSecIKETunPseudoRandFunc() {
        int value = Util.ConvertUnsignedBinary2(this.data, 98);
        return IPSecPseudoRandFunc.from(value);
    }

    public int smf119scIPSecIKETunPseudoRandFuncRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 98);
    }

    public long smf119scIPSecIKETunLifesize() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public Duration smf119scIPSecIKETunLifetime() {
        return Util.Binary4Minutes(this.data, 104);
    }

    public double smf119scIPSecIKETunLifetimeSeconds() {
        return Util.ToSeconds(this.smf119scIPSecIKETunLifetime());
    }

    public long smf119scIPSecIKETunLifetimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration smf119scIPSecIKETunReauthIntvl() {
        return Util.Binary4Minutes(this.data, 108);
    }

    public double smf119scIPSecIKETunReauthIntvlSeconds() {
        return Util.ToSeconds(this.smf119scIPSecIKETunReauthIntvl());
    }

    public long smf119scIPSecIKETunReauthIntvlRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public SignatureMethod smf119scIPSecLclCertSignMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 112);
        return SignatureMethod.from(value);
    }

    public int smf119scIPSecLclCertSignMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public CertEncryptionMethod smf119scIPSecLclCertEncMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 114);
        return CertEncryptionMethod.from(value);
    }

    public int smf119scIPSecLclCertEncMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public CertDigestAlgorithm smf119scIPSecLclCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 116);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119scIPSecLclCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public int smf119scIPSecLclCertSerialLen() {
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public Token smf119scIPSecLclCertSerial() {
        if (this.data.length >= 120 + this.smf119scIPSecLclCertSerialLen()) {
            return new Token(this.data, 120, this.smf119scIPSecLclCertSerialLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(120) + " Data length: " + Integer.toString(this.smf119scIPSecLclCertSerialLen()));
    }

    public TimeType smf119scIPSecLclCertTimeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 140);
        return TimeType.from(value);
    }

    public int smf119scIPSecLclCertTimeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 140);
    }

    public ZonedDateTime smf119scIPSecLclCertTime() {
        switch (this.smf119scIPSecLclCertTimeType()) {
            case GT: {
                return this.smf119scIPSecLclCertTimeGt();
            }
            case UTC: {
                this.smf119scIPSecLclCertTimeUtc();
            }
        }
        return null;
    }

    public String smf119scIPSecLclCertTimeRawValue() {
        return Util.ConvertEbcdic(this.data, 141, 15);
    }

    private ZonedDateTime smf119scIPSecLclCertTimeUtc() {
        return Util.YYMMDDhhmmssZ(this.data, 141);
    }

    private String smf119scIPSecLclCertTimeUtcRawValue() {
        return Util.ConvertEbcdic(this.data, 141, 13);
    }

    private ZonedDateTime smf119scIPSecLclCertTimeGt() {
        return Util.YYYYMMDDhhmmssZ(this.data, 141);
    }

    private String smf119scIPSecLclCertTimeGtRawValue() {
        return Util.ConvertEbcdic(this.data, 141, 15);
    }

    public KeyType smf119scIPSecLclCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 156);
        return KeyType.from(value);
    }

    public int smf119scIPSecLclCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 156);
    }

    public int smf119scIPSecLclCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 158);
    }

    public SignatureMethod smf119scIPSecRmtCertSignMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 160);
        return SignatureMethod.from(value);
    }

    public int smf119scIPSecRmtCertSignMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 160);
    }

    public CertEncryptionMethod smf119scIPSecRmtCertEncMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 162);
        return CertEncryptionMethod.from(value);
    }

    public int smf119scIPSecRmtCertEncMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 162);
    }

    public CertDigestAlgorithm smf119scIPSecRmtCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 164);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119scIPSecRmtCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 164);
    }

    public int smf119scIPSecRmtCertSerialLen() {
        return Util.ConvertUnsignedBinary1(this.data, 167);
    }

    public Token smf119scIPSecRmtCertSerial() {
        if (this.data.length >= 168 + this.smf119scIPSecRmtCertSerialLen()) {
            return new Token(this.data, 168, this.smf119scIPSecRmtCertSerialLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(168) + " Data length: " + Integer.toString(this.smf119scIPSecRmtCertSerialLen()));
    }

    public TimeType smf119scIPSecRmtCertTimeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 188);
        return TimeType.from(value);
    }

    public int smf119scIPSecRmtCertTimeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 188);
    }

    public ZonedDateTime smf119scIPSecRmtCertTime() {
        switch (this.smf119scIPSecRmtCertTimeType()) {
            case GT: {
                return this.smf119scIPSecRmtCertTimeGt();
            }
            case UTC: {
                return this.smf119scIPSecRmtCertTimeUtc();
            }
        }
        return null;
    }

    public String smf119scIPSecRmtCertTimeRawValue() {
        return Util.ConvertEbcdic(this.data, 189, 15);
    }

    private ZonedDateTime smf119scIPSecRmtCertTimeUtc() {
        return Util.YYMMDDhhmmssZ(this.data, 189);
    }

    private String smf119scIPSecRmtCertTimeUtcRawValue() {
        return Util.ConvertEbcdic(this.data, 189, 13);
    }

    private ZonedDateTime smf119scIPSecRmtCertTimeGt() {
        return Util.YYYYMMDDhhmmssZ(this.data, 189);
    }

    private String smf119scIPSecRmtCertTimeGtRawValue() {
        return Util.ConvertEbcdic(this.data, 189, 15);
    }

    public KeyType smf119scIPSecRmtCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 204);
        return KeyType.from(value);
    }

    public int smf119scIPSecRmtCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 204);
    }

    public int smf119scIPSecRmtCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 206);
    }

    public long smf119scIPSecTunID() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public int smf119scIPSecTunFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 212);
    }

    public boolean smf119scIPSecIPv6() {
        return Util.ConvertFlag(this.data, this.smf119scIPSecTunFlags(), 128);
    }

    public boolean smf119scIPSecFIPSMode() {
        return Util.ConvertFlag(this.data, this.smf119scIPSecTunFlags(), 64);
    }

    public TunnelType smf119scIPSecTunType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 213);
        return TunnelType.from(value);
    }

    public int smf119scIPSecTunTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 213);
    }

    public TunnelState smf119scIPSecTunState() {
        int value = Util.ConvertUnsignedBinary1(this.data, 214);
        return TunnelState.from(value);
    }

    public int smf119scIPSecTunStateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 214);
    }

    public IPSecEncapsulationMode smf119scIPSecEncapMode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 216);
        return IPSecEncapsulationMode.from(value);
    }

    public int smf119scIPSecEncapModeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 216);
    }

    public IPSecAuthProto smf119scIPSecAuthProto() {
        int value = Util.ConvertUnsignedBinary1(this.data, 217);
        return IPSecAuthProto.from(value);
    }

    public int smf119scIPSecAuthProtoRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 217);
    }

    public MessageAuthAlgorithm smf119scIPSecAuthAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 218);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119scIPSecAuthAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 218);
    }

    public EncryptionAlgorithm smf119scIPSecEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 220);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119scIPSecEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 220);
    }

    public IPSecDHGroup smf119scIPSecPFSGroup() {
        int value = Util.ConvertUnsignedBinary2(this.data, 222);
        return IPSecDHGroup.from(value);
    }

    public int smf119scIPSecPFSGroupRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 222);
    }

    public long smf119scIPSecLifesize() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public Duration smf119scIPSecLifetime() {
        return Util.Binary4Minutes(this.data, 228);
    }

    public double smf119scIPSecLifetimeSeconds() {
        return Util.ToSeconds(this.smf119scIPSecLifetime());
    }

    public long smf119scIPSecLifetimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public Duration smf119scIPSecVpnLifeExpire() {
        return Util.Binary4Minutes(this.data, 232);
    }

    public double smf119scIPSecVpnLifeExpireSeconds() {
        return Util.ToSeconds(this.smf119scIPSecVpnLifeExpire());
    }

    public long smf119scIPSecVpnLifeExpireRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public static ZertDetailIPSecSection create(byte[] Data2, int offset, int length, boolean ipV6) {
        return new ZertDetailIPSecSection(Data2, offset, length, ipV6);
    }

    static enum Field {
        smf119scIPSecIKETunID(0, 4),
        smf119scIPSecIKEMajVer(4, 1),
        smf119scIPSecIKEMinVer(5, 1),
        smf119scIPSecIKETunKeyExchRule(8, 48),
        smf119scIPSecIKETunLclEndpt(56, 16),
        smf119scIPSecIKETunLclEpIPv4(56, 4),
        smf119scIPSecIKETunLclEpIPv6(56, 16),
        smf119scIPSecIKETunRmtEndpt(72, 16),
        smf119scIPSecIKETunRmtEpIPv4(72, 4),
        smf119scIPSecIKETunRmtEpIPv6(72, 16),
        smf119scIPSecIKETunLclAuthMeth(88, 2),
        smf119scIPSecIKETunRmtAuthMeth(90, 2),
        smf119scIPSecIKETunAuthAlg(92, 2),
        smf119scIPSecIKETunEncAlg(94, 2),
        smf119scIPSecIKETunDHGroup(96, 2),
        smf119scIPSecIKETunPseudoRandFunc(98, 2),
        smf119scIPSecIKETunLifesize(100, 4),
        smf119scIPSecIKETunLifetime(104, 4),
        smf119scIPSecIKETunReauthIntvl(108, 4),
        smf119scIPSecLclCertSignMeth(112, 2),
        smf119scIPSecLclCertEncMeth(114, 2),
        smf119scIPSecLclCertDigestAlg(116, 2),
        smf119scIPSecLclCertSerialLen(119, 1),
        smf119scIPSecLclCertSerial(120, 0),
        smf119scIPSecLclCertTimeType(140, 1),
        smf119scIPSecLclCertTime(141, 15),
        smf119scIPSecLclCertTimeUtc(141, 13),
        smf119scIPSecLclCertTimeGt(141, 15),
        smf119scIPSecLclCertKeyType(156, 2),
        smf119scIPSecLclCertKeyLen(158, 2),
        smf119scIPSecRmtCertSignMeth(160, 2),
        smf119scIPSecRmtCertEncMeth(162, 2),
        smf119scIPSecRmtCertDigestAlg(164, 2),
        smf119scIPSecRmtCertSerialLen(167, 1),
        smf119scIPSecRmtCertSerial(168, 0),
        smf119scIPSecRmtCertTimeType(188, 1),
        smf119scIPSecRmtCertTime(189, 15),
        smf119scIPSecRmtCertTimeUtc(189, 13),
        smf119scIPSecRmtCertTimeGt(189, 15),
        smf119scIPSecRmtCertKeyType(204, 2),
        smf119scIPSecRmtCertKeyLen(206, 2),
        smf119scIPSecTunID(208, 4),
        smf119scIPSecTunFlags(212, 1),
        smf119scIPSecTunType(213, 1),
        smf119scIPSecTunState(214, 1),
        smf119scIPSecEncapMode(216, 1),
        smf119scIPSecAuthProto(217, 1),
        smf119scIPSecAuthAlg(218, 2),
        smf119scIPSecEncAlg(220, 2),
        smf119scIPSecPFSGroup(222, 2),
        smf119scIPSecLifesize(224, 4),
        smf119scIPSecLifetime(228, 4),
        smf119scIPSecVpnLifeExpire(232, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

