/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.CertDigestAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.CertEncryptionMethod;
import com.blackhillsoftware.smf.smf119.zert.EncryptionAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.KeyType;
import com.blackhillsoftware.smf.smf119.zert.MessageAuthAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.SignatureMethod;
import com.blackhillsoftware.smf.smf119.zert.Source;
import com.blackhillsoftware.smf.smf119.zert.TLSKexAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.TLSNegotiatedkeyShare;
import com.blackhillsoftware.smf.smf119.zert.TLSProtocolVersion;

public final class ZertSummaryTLSSection
extends SmfData {
    public static final int SMF119SS_TLS_Enc_Then_Mac = 128;
    public static final int SMF119SS_TLS_Raw_Public_Key_Auth = 64;
    public static final int SMF119SS_TLS_Preshared_Key_Auth = 16;

    private ZertSummaryTLSSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Source smf119ssTlsSource() {
        int value = Util.ConvertUnsignedBinary1(this.data, 0);
        return Source.from(value);
    }

    public int smf119ssTlsSourceRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smf119ssTlsCryptoFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean smf119ssTlsEncThenMac() {
        return Util.ConvertFlag(this.data, this.smf119ssTlsCryptoFlags(), 128);
    }

    public boolean smf119ssTlsRawPublicKeyAuth() {
        return Util.ConvertFlag(this.data, this.smf119ssTlsCryptoFlags(), 64);
    }

    public boolean smf119ssTlsPresharedKeyAuth() {
        return Util.ConvertFlag(this.data, this.smf119ssTlsCryptoFlags(), 16);
    }

    public TLSProtocolVersion smf119ssTlsProtVer() {
        int value = Util.ConvertUnsignedBinary2(this.data, 2);
        return TLSProtocolVersion.from(value);
    }

    public int smf119ssTlsProtVerRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public String smf119ssTlsNegCipher() {
        return Util.ConvertEbcdic(this.data, 4, 6);
    }

    public EncryptionAlgorithm smf119ssTlsCSEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 10);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119ssTlsCSEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public MessageAuthAlgorithm smf119ssTlsCSMsgAuth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 12);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119ssTlsCSMsgAuthRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public TLSKexAlgorithm smf119ssTlsCSKexAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 14);
        return TLSKexAlgorithm.from(value);
    }

    public int smf119ssTlsCSKexAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public SignatureMethod smf119ssTlsSCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 16);
        return SignatureMethod.from(value);
    }

    public int smf119ssTlsSCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public CertEncryptionMethod smf119ssTlsSCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 18);
        return CertEncryptionMethod.from(value);
    }

    public int smf119ssTlsSCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public CertDigestAlgorithm smf119ssTlsSCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 20);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119ssTlsSCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public KeyType smf119ssTlsSCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 22);
        return KeyType.from(value);
    }

    public int smf119ssTlsSCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf119ssTlsSCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public SignatureMethod smf119ssTlsCCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 26);
        return SignatureMethod.from(value);
    }

    public int smf119ssTlsCCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public CertEncryptionMethod smf119ssTlsCCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 28);
        return CertEncryptionMethod.from(value);
    }

    public int smf119ssTlsCCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public CertDigestAlgorithm smf119ssTlsCCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 30);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119ssTlsCCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public KeyType smf119ssTlsCCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 32);
        return KeyType.from(value);
    }

    public int smf119ssTlsCCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf119ssTlsCCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public SignatureMethod smf119ssTlsServerHsSigMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 36);
        return SignatureMethod.from(value);
    }

    public int smf119ssTlsServerHsSigMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public SignatureMethod smf119ssTlsClientHsSigMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 38);
        return SignatureMethod.from(value);
    }

    public int smf119ssTlsClientHsSigMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public TLSNegotiatedkeyShare smf119ssTlsNegKeyShare() {
        int value = Util.ConvertUnsignedBinary2(this.data, 40);
        return TLSNegotiatedkeyShare.from(value);
    }

    public int smf119ssTlsNegKeyShareRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public static ZertSummaryTLSSection create(byte[] Data2, int offset, int length) {
        return new ZertSummaryTLSSection(Data2, offset, length);
    }

    static enum Field {
        smf119ssTlsSource(0, 1),
        smf119ssTlsCryptoFlags(1, 1),
        smf119ssTlsProtVer(2, 2),
        smf119ssTlsNegCipher(4, 6),
        smf119ssTlsCSEncAlg(10, 2),
        smf119ssTlsCSMsgAuth(12, 2),
        smf119ssTlsCSKexAlg(14, 2),
        smf119ssTlsSCertSignatureMethod(16, 2),
        smf119ssTlsSCertEncMethod(18, 2),
        smf119ssTlsSCertDigestAlg(20, 2),
        smf119ssTlsSCertKeyType(22, 2),
        smf119ssTlsSCertKeyLen(24, 2),
        smf119ssTlsCCertSignatureMethod(26, 2),
        smf119ssTlsCCertEncMethod(28, 2),
        smf119ssTlsCCertDigestAlg(30, 2),
        smf119ssTlsCCertKeyType(32, 2),
        smf119ssTlsCCertKeyLen(34, 2),
        smf119ssTlsServerHsSigMethod(36, 2),
        smf119ssTlsClientHsSigMethod(38, 2),
        smf119ssTlsNegKeyShare(40, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

