/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.internal.zertsummary;

import java.util.HashMap;
import java.util.Map;

enum SSHKexMethod {
    UNKNOWN(0),
    NONE(1),
    DH_GEX_SHA256(2),
    DH_GEX_SHA1(3),
    DH_G14_SHA1(4),
    DH_G1_SHA1(5),
    ECDH_SHA2_NISTP_256(6),
    ECDH_SHA2_NISTP_384(7),
    ECDH_SHA2_NISTP_521(8),
    GSS_G1_SHA1(9),
    GSS_G14_SHA1(10),
    GSS_GEX_SHA1(11),
    ECMQV_SHA2(12),
    GSS(13),
    RSA1024_SHA1(14),
    RSA2048_SHA256(15),
    DH_G14_SHA256(16),
    DH_G16_SHA512(17),
    DH_G18_SHA512(18),
    CRV_22519_SHA256(19),
    GSS_G14_SHA256(20),
    GSS_G16_SHA512(21),
    GSS_NISTP256_SHA256(22),
    GSS_CRV_25519_SHA256(23),
    NOT_DEFINED(-16);

    private static Map<Integer, SSHKexMethod> valueMap;
    private final int sshkexmethod;

    private SSHKexMethod(int sshkexmethod) {
        this.sshkexmethod = sshkexmethod;
    }

    public static SSHKexMethod from(int value) {
        SSHKexMethod result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int sshkexmethod() {
        return this.sshkexmethod;
    }

    static {
        valueMap = new HashMap<Integer, SSHKexMethod>();
        for (SSHKexMethod x : SSHKexMethod.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.sshkexmethod, x);
        }
    }
}

