/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.internal.zertsummary;

import java.util.HashMap;
import java.util.Map;

enum SignatureMethod {
    UNKNOWN(0),
    NONE(1),
    RSA_MD2(2),
    RSA_MD5(3),
    RSA_SHA1(4),
    DSA_SHA1(5),
    RSA_SHA224(6),
    RSA_SHA256(7),
    RSA_SHA384(8),
    RSA_SHA512(9),
    ECDSA_SHA1(10),
    ECDSA_SHA224(11),
    ECDSA_SHA256(12),
    ECDSA_SHA384(13),
    ECDSA_SHA512(14),
    DSA_SHA224(15),
    DSA_SHA256(16),
    RSA_PSS_RSAE_SHA256(17),
    RSA_PSS_RSAE_SHA384(18),
    RSA_PSS_RSAE_SHA512(19),
    ED25519(20),
    ED448(21),
    RSA_PSS_PSS_SHA256(22),
    RSA_PSS_PSS_SHA384(23),
    RSA_PSS_PSS_SHA512(24),
    NOT_DEFINED(-16);

    private static Map<Integer, SignatureMethod> valueMap;
    private final int signaturemethod;

    private SignatureMethod(int signaturemethod) {
        this.signaturemethod = signaturemethod;
    }

    public static SignatureMethod from(int value) {
        SignatureMethod result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int signaturemethod() {
        return this.signaturemethod;
    }

    static {
        valueMap = new HashMap<Integer, SignatureMethod>();
        for (SignatureMethod x : SignatureMethod.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.signaturemethod, x);
        }
    }
}

