/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.zert;

import java.util.HashMap;
import java.util.Map;

public enum IPSecAuthMethod {
    UNKNOWN(0),
    NONE(1),
    RSA(2),
    PRESHARED_KEY(3),
    ECDSA_256(4),
    ECDSA_384(5),
    ECDSA_521(6),
    DIGITAL_SIGN(7),
    NOT_DEFINED(-16);

    private static Map<Integer, IPSecAuthMethod> valueMap;
    private final int ipsecauthmethod;

    private IPSecAuthMethod(int ipsecauthmethod) {
        this.ipsecauthmethod = ipsecauthmethod;
    }

    public static IPSecAuthMethod from(int value) {
        IPSecAuthMethod result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int ipsecauthmethod() {
        return this.ipsecauthmethod;
    }

    static {
        valueMap = new HashMap<Integer, IPSecAuthMethod>();
        for (IPSecAuthMethod x : IPSecAuthMethod.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.ipsecauthmethod, x);
        }
    }
}

