/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.zert;

import java.util.HashMap;
import java.util.Map;

public enum KeyType {
    UNKNOWN(0),
    NONE(1),
    RSA(2),
    DSA(3),
    DH(4),
    ECC(5),
    RSA1(6),
    RSA_CERT(7),
    DSA_CERT(8),
    ECDSA_CERT(9),
    ED25519(10),
    ED25519_CERT01(11),
    ECDSA_SK(18),
    ECDSA_SK_CERT(19),
    ED25519_SK(20),
    ED25519_SK_CERT(21),
    NOT_DEFINED(-16);

    private static Map<Integer, KeyType> valueMap;
    private final int keytype;

    private KeyType(int keytype) {
        this.keytype = keytype;
    }

    public static KeyType from(int value) {
        KeyType result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int keytype() {
        return this.keytype;
    }

    static {
        valueMap = new HashMap<Integer, KeyType>();
        for (KeyType x : KeyType.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.keytype, x);
        }
    }
}

