/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf121;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class JavaRuntimeSection
extends SmfData {
    public static final int SMF121JRS_FF1_CPU = 128;

    private JavaRuntimeSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf121jrsFdflags() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int smf121jrsFf1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf121jrsFf1Cpu() {
        return Util.ConvertFlag(this.data, this.smf121jrsFf1(), 128);
    }

    public int smf121jrsFf2() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int smf121jrsFf3() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public int smf121jrsFf4() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public String smf121jrsName() {
        return Util.ConvertEbcdic(this.data, 4, 80);
    }

    public ZonedDateTime smf121jrsStrttme() {
        return Util.Binary8MillisSinceEpochTime(this.data, 84);
    }

    public long smf121jrsStrttmeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 84);
    }

    public Duration smf121jrsUptime() {
        return Util.Binary8MSSeconds(this.data, 92);
    }

    public double smf121jrsUptimeSeconds() {
        return Util.ToSeconds(this.smf121jrsUptime());
    }

    public BigInteger smf121jrsUptimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public String smf121jrsGcmode() {
        return Util.ConvertEbcdic(this.data, 100, 40);
    }

    public long smf121jrsPeakthrd() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long smf121jrsCurrthrd() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public Duration smf121jrsAppcpu() {
        if (Util.ConvertSignedBinary8(this.data, 148) == -1L) {
            return null;
        }
        return Util.Binary8USSeconds(this.data, 148);
    }

    public double smf121jrsAppcpuSeconds() {
        return Util.ToSeconds(this.smf121jrsAppcpu());
    }

    public BigInteger smf121jrsAppcpuRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 148);
    }

    public Duration smf121jrsSyscpu() {
        if (Util.ConvertSignedBinary8(this.data, 156) == -1L) {
            return null;
        }
        return Util.Binary8USSeconds(this.data, 156);
    }

    public double smf121jrsSyscpuSeconds() {
        return Util.ToSeconds(this.smf121jrsSyscpu());
    }

    public BigInteger smf121jrsSyscpuRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 156);
    }

    public Duration smf121jrsGccpu() {
        if (Util.ConvertSignedBinary8(this.data, 164) == -1L) {
            return null;
        }
        return Util.Binary8USSeconds(this.data, 164);
    }

    public double smf121jrsGccpuSeconds() {
        return Util.ToSeconds(this.smf121jrsGccpu());
    }

    public BigInteger smf121jrsGccpuRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 164);
    }

    public Duration smf121jrsJitcpu() {
        if (Util.ConvertSignedBinary8(this.data, 172) == -1L) {
            return null;
        }
        return Util.Binary8USSeconds(this.data, 172);
    }

    public double smf121jrsJitcpuSeconds() {
        return Util.ToSeconds(this.smf121jrsJitcpu());
    }

    public BigInteger smf121jrsJitcpuRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 172);
    }

    public static JavaRuntimeSection create(byte[] Data2, int offset, int length) {
        return new JavaRuntimeSection(Data2, offset, length);
    }

    static enum Field {
        smf121jrsFdflags(0, 4),
        smf121jrsFf1(0, 1),
        smf121jrsFf2(1, 1),
        smf121jrsFf3(2, 1),
        smf121jrsFf4(3, 1),
        smf121jrsName(4, 80),
        smf121jrsStrttme(84, 8),
        smf121jrsUptime(92, 8),
        smf121jrsGcmode(100, 40),
        smf121jrsPeakthrd(140, 4),
        smf121jrsCurrthrd(144, 4),
        smf121jrsAppcpu(148, 8),
        smf121jrsSyscpu(156, 8),
        smf121jrsGccpu(164, 8),
        smf121jrsJitcpu(172, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

