/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class AdditionalDatasetCharacteristics
extends SmfData {
    public static final int SMF14BLK = 128;
    public static final int SMF14FLGP = 64;
    public static final int SMF14DST = 32;
    public static final int SMF14ALS = 16;
    public static final int SMF14UPF = 128;
    public static final int SMF14EADSCB = 64;
    public static final int SMF14EX31 = 32;
    public static final int SMF14XTIO = 16;
    public static final int SMF14DSENCRYPTOK = 8;
    public static final int SMF14DSENCARCHKEY = 4;
    public static final int SMF14DSENCREJ = 2;

    private AdditionalDatasetCharacteristics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf14bfg() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf14bfg0() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf14blk() {
        return Util.ConvertFlag(this.data, this.smf14bfg0(), 128);
    }

    public boolean smf14flgp() {
        return Util.ConvertFlag(this.data, this.smf14bfg0(), 64);
    }

    public boolean smf14dst() {
        return Util.ConvertFlag(this.data, this.smf14bfg0(), 32);
    }

    public boolean smf14als() {
        return Util.ConvertFlag(this.data, this.smf14bfg0(), 16);
    }

    public int smf14bfg1() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public long smf14lbs() {
        return Util.ConvertUnsignedBinary8(this.data, 2);
    }

    public BigInteger smf14lbsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 2);
    }

    public int smf14flgs() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int smf14flg1() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean smf14upf() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 128);
    }

    public boolean smf14eadscb() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 64);
    }

    public boolean smf14ex31() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 32);
    }

    public boolean smf14xtio() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 16);
    }

    public boolean smf14dsencryptok() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 8);
    }

    public boolean smf14dsencarchkey() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 4);
    }

    public boolean smf14dsencrej() {
        return Util.ConvertFlag(this.data, this.smf14flg1(), 2);
    }

    public int smf14flg2() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public int smf14dsver() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public String smf14ali() {
        return Util.ConvertEbcdic(this.data, 13, 44);
    }

    public static AdditionalDatasetCharacteristics create(byte[] Data2, int offset, int length) {
        return new AdditionalDatasetCharacteristics(Data2, offset, length);
    }

    static enum Field {
        smf14bfg(0, 2),
        smf14bfg0(0, 1),
        smf14bfg1(1, 1),
        smf14lbs(2, 8),
        smf14flgs(10, 2),
        smf14flg1(10, 1),
        smf14flg2(11, 1),
        smf14dsver(12, 1),
        smf14ali(13, 44);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

