/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class CcsidInformationSection
extends SmfData {
    public static final int SMF14IBM = 128;
    public static final int SMF14OUT = 64;
    public static final int SMF14MOD = 32;
    public static final int SMF14UDF = 16;
    public static final int SMF14TDF = 8;
    public static final int SMF14IGN = 4;

    private CcsidInformationSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf14cfg() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf14ibm() {
        return Util.ConvertFlag(this.data, this.smf14cfg(), 128);
    }

    public boolean smf14out() {
        return Util.ConvertFlag(this.data, this.smf14cfg(), 64);
    }

    public boolean smf14mod() {
        return Util.ConvertFlag(this.data, this.smf14cfg(), 32);
    }

    public boolean smf14udf() {
        return Util.ConvertFlag(this.data, this.smf14cfg(), 16);
    }

    public boolean smf14tdf() {
        return Util.ConvertFlag(this.data, this.smf14cfg(), 8);
    }

    public boolean smf14ign() {
        return Util.ConvertFlag(this.data, this.smf14cfg(), 4);
    }

    public long smf14usr() {
        return Util.ConvertUnsignedBinary4(this.data, 1);
    }

    public long smf14tpe() {
        return Util.ConvertUnsignedBinary4(this.data, 5);
    }

    public long smf14lbl() {
        return Util.ConvertUnsignedBinary4(this.data, 9);
    }

    public static CcsidInformationSection create(byte[] Data2, int offset, int length) {
        return new CcsidInformationSection(Data2, offset, length);
    }

    static enum Field {
        smf14cfg(0, 1),
        smf14usr(1, 4),
        smf14tpe(5, 4),
        smf14lbl(9, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

