/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.util.HashMap;
import java.util.Map;

public class ExtendedInformationSegment
extends SmfData {
    public static final int SMF14XDS = 1;
    public static final int SMF14SMS = 2;
    public static final int SMF14STP = 3;
    public static final int SMF14AV4 = 4;
    public static final int SMF14ADC = 5;
    public static final int SMF14PDSE = 6;
    public static final int SMF14KEKL = 7;
    public static final int SMF14RAS8 = 8;
    public static final int SMF14DENCR = 9;

    ExtendedInformationSegment(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf14esl() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf14sty() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf14xds() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 1);
    }

    public boolean smf14sms() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 2);
    }

    public boolean smf14stp() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 3);
    }

    public boolean smf14av4() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 4);
    }

    public boolean smf14adc() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 5);
    }

    public boolean smf14pdse() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 6);
    }

    public boolean smf14kekl() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 7);
    }

    public boolean smf14ras8() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 8);
    }

    public boolean smf14dencr() {
        return Util.ConvertEquateValue(this.data, this.smf14sty(), 9);
    }

    public static ExtendedInformationSegment create(byte[] Data2, int offset, int length) {
        return new ExtendedInformationSegment(Data2, offset, length);
    }

    public static enum ExtendedInformationSegmentType {
        CompressedFormatDatasetSection(1),
        SmsClassSection(2),
        StepInformationSection(3),
        CcsidInformationSection(4),
        AdditionalDatasetCharacteristics(5),
        PdseStatistics(6),
        TapeEncryptionData(7),
        RasSection(8),
        EncryptedDasdDatasetSection(9);

        private static final Map<Integer, ExtendedInformationSegmentType> intToTypeMap;
        private final transient int id;

        public static ExtendedInformationSegmentType fromInt(int i) {
            ExtendedInformationSegmentType type = intToTypeMap.get(i);
            return type;
        }

        private ExtendedInformationSegmentType(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }

        static {
            intToTypeMap = new HashMap<Integer, ExtendedInformationSegmentType>();
            for (ExtendedInformationSegmentType type : ExtendedInformationSegmentType.values()) {
                intToTypeMap.put(type.getValue(), type);
            }
        }
    }

    static enum Field {
        smf14esl(0, 2),
        smf14sty(3, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

