/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf16;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf16.DataSection;
import com.blackhillsoftware.smf.smf16.InputDatasetSection;
import com.blackhillsoftware.smf.smf16.OutfilDatasetSection;
import com.blackhillsoftware.smf.smf16.ProductSection;
import com.blackhillsoftware.smf.smf16.RecordLengthDistributionSection;
import com.blackhillsoftware.smf.smf16.SortoutDatasetSection;
import com.blackhillsoftware.smf.smf16.ZSortStatisticsSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public final class Smf16Record
extends SmfRecord {
    private List<ProductSection> m_ProductSection = null;
    private List<DataSection> m_DataSection = null;
    private List<RecordLengthDistributionSection> m_RecordLengthDistributionSection = null;
    private List<InputDatasetSection> m_InputDatasetSection = null;
    private List<SortoutDatasetSection> m_SortoutDatasetSection = null;
    private List<OutfilDatasetSection> m_OutfilDatasetSection = null;
    private List<ZSortStatisticsSection> m_ZSortStatisticsSections = null;
    public static final int ICESUBSY = 128;
    public static final int ICEMVSES = 8;
    public static final int ICEMVSXA = 4;
    public static final int ICEMVS37 = 2;
    public static final int ICERSUBS = 1;
    public static final int ICERSUBF = 2;
    public static final int ICERSUBU = 3;

    public Smf16Record(byte[] data) {
        super(data);
        this.checkType();
    }

    protected void checkType() {
        if (this.recordType() != 16) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf16Record(SmfRecord record) {
        super(record);
        this.checkType();
    }

    public static Smf16Record from(SmfRecord record) {
        return new Smf16Record(record);
    }

    public static Smf16Record from(byte[] data) {
        return new Smf16Record(data);
    }

    public List<ProductSection> productSections() {
        this.m_ProductSection = Util.sectionsFromTriplet(this.m_ProductSection, this.data, () -> this.iceprod(), () -> this.iceprodl(), () -> this.iceprodn(), ProductSection::create);
        return this.m_ProductSection;
    }

    public List<DataSection> dataSections() {
        this.m_DataSection = Util.sectionsFromTriplet(this.m_DataSection, this.data, () -> this.icedata(), () -> this.icedatal(), () -> this.icedatan(), DataSection::create);
        return this.m_DataSection;
    }

    public List<RecordLengthDistributionSection> recordLengthDistributionSections() {
        this.m_RecordLengthDistributionSection = Util.sectionsFromTriplet(this.m_RecordLengthDistributionSection, this.data, () -> this.icestat(), () -> this.icestatl(), () -> this.icestatn(), RecordLengthDistributionSection::create);
        return this.m_RecordLengthDistributionSection;
    }

    public List<InputDatasetSection> inputDatasetSections() {
        this.m_InputDatasetSection = Util.sectionsFromTriplet(this.m_InputDatasetSection, this.data, () -> this.iceinds(), () -> this.iceindsl(), () -> this.iceindsn(), InputDatasetSection::create);
        return this.m_InputDatasetSection;
    }

    public List<SortoutDatasetSection> sortoutDatasetSections() {
        this.m_SortoutDatasetSection = Util.sectionsFromTriplet(this.m_SortoutDatasetSection, this.data, () -> this.iceotds(), () -> this.iceotdsl(), () -> this.iceotdsn(), SortoutDatasetSection::create);
        return this.m_SortoutDatasetSection;
    }

    public List<OutfilDatasetSection> outfilDatasetSections() {
        this.m_OutfilDatasetSection = Util.sectionsFromTriplet(this.m_OutfilDatasetSection, this.data, () -> this.iceofds(), () -> this.iceofdsl(), () -> this.iceofdsn(), OutfilDatasetSection::create);
        return this.m_OutfilDatasetSection;
    }

    public List<ZSortStatisticsSection> zSortStatisticsSections() {
        this.m_ZSortStatisticsSections = Util.sectionsFromTriplet(this.m_ZSortStatisticsSections, this.data, () -> this.icezsrt(), () -> this.icezsrtl(), () -> this.icezsrtn(), ZSortStatisticsSection::create);
        return this.m_ZSortStatisticsSections;
    }

    public long icerdw() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int icesind() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean icesubsy() {
        return Util.ConvertFlag(this.data, this.icesind(), 128);
    }

    public boolean icemvses() {
        return Util.ConvertFlag(this.data, this.icesind(), 8);
    }

    public boolean icemvsxa() {
        return Util.ConvertFlag(this.data, this.icesind(), 4);
    }

    public boolean icemvs37() {
        return Util.ConvertFlag(this.data, this.icesind(), 2);
    }

    public int icertyp() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime icebtime() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long icebtimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate icebdate() {
        return Util.SMFDate(this.data, 10);
    }

    public int icebdateRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String icesid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String icejobnm() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime icerst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long icerstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate icerds() {
        return Util.SMFDate(this.data, 30);
    }

    public int icerdsRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String iceuif() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public int icestn() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public int icetrn() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public String icesubid() {
        return Util.ConvertEbcdic(this.data, 46, 4);
    }

    public int icersub() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int iceprod() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int iceprodl() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int iceprodn() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int icedata() {
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int icedatal() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int icedatan() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int icestat() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int icestatl() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int icestatn() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int iceinds() {
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int iceindsl() {
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int iceindsn() {
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int iceotds() {
        return Util.ConvertSignedBinary4(this.data, 84);
    }

    public int iceotdsl() {
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public int iceotdsn() {
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public int iceofds() {
        return Util.ConvertSignedBinary4(this.data, 92);
    }

    public int iceofdsl() {
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public int iceofdsn() {
        return Util.ConvertUnsignedBinary2(this.data, 98);
    }

    public int icehdrln() {
        return Util.ConvertUnsignedBinary2(this.data, 100);
    }

    public int icespgn() {
        return Util.ConvertUnsignedBinary2(this.data, 102);
    }

    public String iceuser() {
        return Util.ConvertEbcdic(this.data, 104, 8);
    }

    public String icegroup() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    public int icezsrt() {
        return Util.ConvertSignedBinary4(this.data, 128);
    }

    public int icezsrtl() {
        return Util.ConvertUnsignedBinary2(this.data, 132);
    }

    public int icezsrtn() {
        return Util.ConvertUnsignedBinary2(this.data, 134);
    }

    static enum Field {
        icerdw(0, 4),
        icesind(4, 1),
        icertyp(5, 1),
        icebtime(6, 4),
        icebdate(10, 4),
        icesid(14, 4),
        icejobnm(18, 8),
        icerst(26, 4),
        icerds(30, 4),
        iceuif(34, 8),
        icestn(42, 1),
        icetrn(44, 2),
        icesubid(46, 4),
        icersub(50, 2),
        iceprod(52, 4),
        iceprodl(56, 2),
        iceprodn(58, 2),
        icedata(60, 4),
        icedatal(64, 2),
        icedatan(66, 2),
        icestat(68, 4),
        icestatl(72, 2),
        icestatn(74, 2),
        iceinds(76, 4),
        iceindsl(80, 2),
        iceindsn(82, 2),
        iceotds(84, 4),
        iceotdsl(88, 2),
        iceotdsn(90, 2),
        iceofds(92, 4),
        iceofdsl(96, 2),
        iceofdsn(98, 2),
        icehdrln(100, 2),
        icespgn(102, 2),
        iceuser(104, 8),
        icegroup(112, 8),
        icezsrt(128, 4),
        icezsrtl(132, 2),
        icezsrtn(134, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

