/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class SortoutDatasetSection
extends SmfData {
    public static final int ICEOTPIP = 128;
    public static final int ICEOTSTR = 64;
    public static final int ICEOTCPR = 32;
    public static final int ICEOTEA = 16;
    public static final int ICEOTHFS = 8;
    public static final int ICEOTEXP = 128;
    public static final int ICEOTVSM = 64;
    public static final int ICEOTBSM = 32;
    public static final int ICEOTTAP = 128;
    public static final int ICEOTDAS = 64;
    public static final int ICEOTSPD = 32;
    public static final int ICEOTEND = 104;

    private SortoutDatasetSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int iceotfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean iceotpip() {
        return Util.ConvertFlag(this.data, this.iceotfl1(), 128);
    }

    public boolean iceotstr() {
        return Util.ConvertFlag(this.data, this.iceotfl1(), 64);
    }

    public boolean iceotcpr() {
        return Util.ConvertFlag(this.data, this.iceotfl1(), 32);
    }

    public boolean iceotea() {
        return Util.ConvertFlag(this.data, this.iceotfl1(), 16);
    }

    public boolean iceothfs() {
        return Util.ConvertFlag(this.data, this.iceotfl1(), 8);
    }

    public int iceotamb() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean iceotexp() {
        return Util.ConvertFlag(this.data, this.iceotamb(), 128);
    }

    public boolean iceotvsm() {
        return Util.ConvertFlag(this.data, this.iceotamb(), 64);
    }

    public boolean iceotbsm() {
        return Util.ConvertFlag(this.data, this.iceotamb(), 32);
    }

    public int iceottyp() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean iceottap() {
        return Util.ConvertFlag(this.data, this.iceottyp(), 128);
    }

    public boolean iceotdas() {
        return Util.ConvertFlag(this.data, this.iceottyp(), 64);
    }

    public boolean iceotspd() {
        return Util.ConvertFlag(this.data, this.iceottyp(), 32);
    }

    public int iceotrcf() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public long iceotbyt() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger iceotbytAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long iceotrec() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger iceotrecAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long iceotamc() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger iceotamcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public int iceotlrl() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int iceotbkz() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String iceotddn() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String iceotnam() {
        return Util.ConvertEbcdic(this.data, 48, 44);
    }

    public String iceotvol() {
        return Util.ConvertEbcdic(this.data, 92, 6);
    }

    public long iceotbkf() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public static SortoutDatasetSection create(byte[] Data2, int offset, int length) {
        return new SortoutDatasetSection(Data2, offset, length);
    }

    static enum Field {
        iceotfl1(0, 1),
        iceotamb(1, 1),
        iceottyp(2, 1),
        iceotrcf(3, 1),
        iceotbyt(8, 8),
        iceotrec(16, 8),
        iceotamc(24, 8),
        iceotlrl(34, 2),
        iceotbkz(38, 2),
        iceotddn(40, 8),
        iceotnam(48, 44),
        iceotvol(92, 6),
        iceotbkf(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

