/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf2;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf2Record
extends SmfRecord {
    public static final int SMFRCD2 = 0;

    public Smf2Record(byte[] data) {
        super(data);
        if (this.recordType() != 2) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf2Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 2) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf2Record from(SmfRecord record) {
        return new Smf2Record(record);
    }

    public static Smf2Record from(byte[] data) {
        return new Smf2Record(data);
    }

    public int smf2len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf2seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf2flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf2rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf2tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf2tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf2dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf2dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf2sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    static enum Field {
        smf2len(0, 2),
        smf2seg(2, 2),
        smf2flg(4, 1),
        smf2rty(5, 1),
        smf2tme(6, 4),
        smf2dte(10, 4),
        smf2sid(14, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

