/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf23;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    Header(byte[] Data2) {
        super(Data2);
    }

    public int smf23len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf23seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf23flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf23rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf23tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf23tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf23dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf23dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf23sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public byte[] smf23sls() {
        if (this.data.length >= 44) {
            byte[] result = new byte[24];
            System.arraycopy(this.data, 20, result, 0, 24);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(20) + " Data length: " + Integer.toString(24));
    }

    public int smf23pof() {
        return Util.ConvertSignedBinary4(this.data, 20);
    }

    public int smf23pln() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf23pon() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int smf23sof() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf23sln() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf23son() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf23rof() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf23rln() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf23ron() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf23lof() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf23lln() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf23lon() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf23nof() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf23nln() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf23non() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf23bof() {
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf23bln() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf23bon() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf23len(0, 2),
        smf23seg(2, 2),
        smf23flg(4, 1),
        smf23rty(5, 1),
        smf23tme(6, 4),
        smf23dte(10, 4),
        smf23sid(14, 4),
        smf23sls(20, 24),
        smf23pof(20, 4),
        smf23pln(24, 2),
        smf23pon(26, 2),
        smf23sof(28, 4),
        smf23sln(32, 2),
        smf23son(34, 2),
        smf23rof(36, 4),
        smf23rln(40, 2),
        smf23ron(42, 2),
        smf23lof(44, 4),
        smf23lln(48, 2),
        smf23lon(50, 2),
        smf23nof(52, 4),
        smf23nln(56, 2),
        smf23non(58, 2),
        smf23bof(60, 4),
        smf23bln(64, 2),
        smf23bon(66, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

