/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf23;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class SystemSection
extends SmfData {
    private SystemSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public LocalTime smf23int() {
        return Util.EBCDIC6hhmmss(this.data, 0);
    }

    public String smf23intRawValue() {
        return Util.ConvertEbcdic(this.data, 0, 6);
    }

    public String smf23rls() {
        return Util.ConvertEbcdic(this.data, 6, 4);
    }

    public String smf23osl() {
        return Util.ConvertEbcdic(this.data, 10, 8);
    }

    public ZonedDateTime smf23tod() {
        return Util.Binary8xStckTime(this.data, 18);
    }

    public BigInteger smf23todRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 18);
    }

    public String smf23syn() {
        return Util.ConvertEbcdic(this.data, 26, 8);
    }

    public String smf23syp() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public static SystemSection create(byte[] Data2, int offset, int length) {
        return new SystemSection(Data2, offset, length);
    }

    static enum Field {
        smf23int(0, 6),
        smf23rls(6, 4),
        smf23osl(10, 8),
        smf23tod(18, 8),
        smf23syn(26, 8),
        smf23syp(34, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

