/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf3;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf3Record
extends SmfRecord {
    public static final int SMFRCD3 = 0;

    public Smf3Record(byte[] data) {
        super(data);
        if (this.recordType() != 3) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf3Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 3) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf3Record from(SmfRecord record) {
        return new Smf3Record(record);
    }

    public static Smf3Record from(byte[] data) {
        return new Smf3Record(data);
    }

    public int smf3len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf3seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf3flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf3rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf3tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf3tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf3dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf3dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf3sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    static enum Field {
        smf3len(0, 2),
        smf3seg(2, 2),
        smf3flg(4, 1),
        smf3rty(5, 1),
        smf3tme(6, 4),
        smf3dte(10, 4),
        smf3sid(14, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

