/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF30_RecCont_FirstRec = 128;
    public static final int SMF30_RecCont_AdditionalRec = 64;
    public static final int SMF30_RecCont_LastRec = 32;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    Header(byte[] Data2) {
        super(Data2);
    }

    public int smf30len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf30seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf30flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf30rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf30tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf30tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf30dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf30dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf30sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf30wid() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf30stp() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf30sof() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    Triplet smf30sofTriplet() {
        return Triplet.get422Triplet(this.data, 24);
    }

    public int smf30sln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf30son() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smf30iof() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    Triplet smf30iofTriplet() {
        return Triplet.get422Triplet(this.data, 32);
    }

    public int smf30iln() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smf30ion() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public int smf30uof() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    Triplet smf30uofTriplet() {
        return Triplet.get422Triplet(this.data, 40);
    }

    public int smf30uln() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int smf30uon() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public int smf30tof() {
        return Util.ConvertSignedBinary4(this.data, 48);
    }

    Triplet smf30tofTriplet() {
        return Triplet.get422Triplet(this.data, 48);
    }

    public int smf30tln() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf30ton() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public int smf30cof() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    Triplet smf30cofTriplet() {
        return Triplet.get422Triplet(this.data, 56);
    }

    public int smf30cln() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int smf30con() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int smf30aof() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    Triplet smf30aofTriplet() {
        return Triplet.get422Triplet(this.data, 64);
    }

    public int smf30aln() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int smf30aon() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public int smf30rof() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    Triplet smf30rofTriplet() {
        return Triplet.get422Triplet(this.data, 72);
    }

    public int smf30rln() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int smf30ron() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public int smf30pof() {
        return Util.ConvertSignedBinary4(this.data, 80);
    }

    Triplet smf30pofTriplet() {
        return Triplet.get422Triplet(this.data, 80);
    }

    public int smf30pln() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public int smf30pon() {
        return Util.ConvertUnsignedBinary2(this.data, 86);
    }

    public int smf30oof() {
        return Util.ConvertSignedBinary4(this.data, 88);
    }

    Triplet smf30oofTriplet() {
        return Triplet.get422Triplet(this.data, 88);
    }

    public int smf30oln() {
        return Util.ConvertUnsignedBinary2(this.data, 92);
    }

    public int smf30oon() {
        return Util.ConvertUnsignedBinary2(this.data, 94);
    }

    public int smf30eof() {
        return Util.ConvertSignedBinary4(this.data, 96);
    }

    Triplet smf30eofTriplet() {
        return Triplet.get422Triplet(this.data, 96);
    }

    public int smf30eln() {
        return Util.ConvertUnsignedBinary2(this.data, 100);
    }

    public int smf30eon() {
        return Util.ConvertUnsignedBinary2(this.data, 102);
    }

    public int smf30eor() {
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public long smf30eos() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public int smf30dro() {
        return Util.ConvertSignedBinary4(this.data, 112);
    }

    Triplet smf30droTriplet() {
        return Triplet.get422Triplet(this.data, 112);
    }

    public int smf30drl() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public int smf30drn() {
        return Util.ConvertUnsignedBinary2(this.data, 118);
    }

    public int smf30aro() {
        return Util.ConvertSignedBinary4(this.data, 120);
    }

    Triplet smf30aroTriplet() {
        return Triplet.get422Triplet(this.data, 120);
    }

    public int smf30arl() {
        return Util.ConvertUnsignedBinary2(this.data, 124);
    }

    public int smf30arn() {
        return Util.ConvertUnsignedBinary2(this.data, 126);
    }

    public int smf30opo() {
        return Util.ConvertSignedBinary4(this.data, 128);
    }

    Triplet smf30opoTriplet() {
        return Triplet.get422Triplet(this.data, 128);
    }

    public int smf30opl() {
        return Util.ConvertUnsignedBinary2(this.data, 132);
    }

    public int smf30opn() {
        return Util.ConvertUnsignedBinary2(this.data, 134);
    }

    public long smf30opm() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public int smf30udo() {
        return Util.ConvertSignedBinary4(this.data, 140);
    }

    Triplet smf30udoTriplet() {
        return Triplet.get422Triplet(this.data, 140);
    }

    public int smf30udl() {
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public int smf30udn() {
        return Util.ConvertUnsignedBinary2(this.data, 146);
    }

    public long smf30uds() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public int smf30rmo() {
        return Util.ConvertSignedBinary4(this.data, 152);
    }

    Triplet smf30rmoTriplet() {
        return Triplet.get422Triplet(this.data, 152);
    }

    public int smf30rml() {
        return Util.ConvertUnsignedBinary2(this.data, 156);
    }

    public int smf30rmn() {
        return Util.ConvertUnsignedBinary2(this.data, 158);
    }

    public long smf30rms() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public int smf30mof() {
        return Util.ConvertSignedBinary4(this.data, 164);
    }

    Triplet smf30mofTriplet() {
        return Triplet.get422Triplet(this.data, 164);
    }

    public int smf30mln() {
        return Util.ConvertUnsignedBinary2(this.data, 168);
    }

    public int smf30mno() {
        return Util.ConvertUnsignedBinary2(this.data, 170);
    }

    public long smf30mos() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public int smf30cdo() {
        return Util.ConvertSignedBinary4(this.data, 176);
    }

    Triplet smf30cdoTriplet() {
        return Triplet.get422Triplet(this.data, 176);
    }

    public int smf30cdl() {
        return Util.ConvertUnsignedBinary2(this.data, 180);
    }

    public int smf30cdn() {
        return Util.ConvertUnsignedBinary2(this.data, 182);
    }

    public int smf30uso() {
        return Util.ConvertSignedBinary4(this.data, 184);
    }

    Triplet smf30usoTriplet() {
        return Triplet.get422Triplet(this.data, 184);
    }

    public int smf30usl() {
        return Util.ConvertUnsignedBinary2(this.data, 188);
    }

    public int smf30usn() {
        return Util.ConvertUnsignedBinary2(this.data, 190);
    }

    public int smf30cpo() {
        return Util.ConvertSignedBinary4(this.data, 192);
    }

    Triplet smf30cpoTriplet() {
        return Triplet.get422Triplet(this.data, 192);
    }

    public int smf30cpl() {
        return Util.ConvertUnsignedBinary2(this.data, 196);
    }

    public int smf30cpn() {
        return Util.ConvertUnsignedBinary2(this.data, 198);
    }

    public long smf30cpa() {
        if (this.data.length <= Field.smf30cpa.offset) {
            return 0L;
        }
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public int smf30npo() {
        return Util.ConvertSignedBinary4(this.data, 204);
    }

    Triplet smf30npoTriplet() {
        return Triplet.get422Triplet(this.data, 204);
    }

    public int smf30npl() {
        return Util.ConvertUnsignedBinary2(this.data, 208);
    }

    public int smf30npn() {
        return Util.ConvertUnsignedBinary2(this.data, 210);
    }

    public long smf30npa() {
        if (this.data.length <= Field.smf30npa.offset) {
            return 0L;
        }
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public int smf30ContRecsToFollow() {
        return Util.ConvertUnsignedBinary2(this.data, 216);
    }

    public int smf30RecContFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 218);
    }

    public boolean smf30RecContFirstRec() {
        return Util.ConvertFlag(this.data, this.smf30RecContFlags(), 128);
    }

    public boolean smf30RecContAdditionalRec() {
        return Util.ConvertFlag(this.data, this.smf30RecContFlags(), 64);
    }

    public boolean smf30RecContLastRec() {
        return Util.ConvertFlag(this.data, this.smf30RecContFlags(), 32);
    }

    public int smf30cno() {
        return Util.ConvertSignedBinary4(this.data, 220);
    }

    Triplet smf30cnoTriplet() {
        return Triplet.get422Triplet(this.data, 220);
    }

    public int smf30cnl() {
        return Util.ConvertUnsignedBinary2(this.data, 224);
    }

    public int smf30cnn() {
        return Util.ConvertUnsignedBinary2(this.data, 226);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf30len(0, 2),
        smf30seg(2, 2),
        smf30flg(4, 1),
        smf30rty(5, 1),
        smf30tme(6, 4),
        smf30dte(10, 4),
        smf30sid(14, 4),
        smf30wid(18, 4),
        smf30stp(22, 2),
        smf30sof(24, 4),
        smf30sln(28, 2),
        smf30son(30, 2),
        smf30iof(32, 4),
        smf30iln(36, 2),
        smf30ion(38, 2),
        smf30uof(40, 4),
        smf30uln(44, 2),
        smf30uon(46, 2),
        smf30tof(48, 4),
        smf30tln(52, 2),
        smf30ton(54, 2),
        smf30cof(56, 4),
        smf30cln(60, 2),
        smf30con(62, 2),
        smf30aof(64, 4),
        smf30aln(68, 2),
        smf30aon(70, 2),
        smf30rof(72, 4),
        smf30rln(76, 2),
        smf30ron(78, 2),
        smf30pof(80, 4),
        smf30pln(84, 2),
        smf30pon(86, 2),
        smf30oof(88, 4),
        smf30oln(92, 2),
        smf30oon(94, 2),
        smf30eof(96, 4),
        smf30eln(100, 2),
        smf30eon(102, 2),
        smf30eor(104, 2),
        smf30eos(108, 4),
        smf30dro(112, 4),
        smf30drl(116, 2),
        smf30drn(118, 2),
        smf30aro(120, 4),
        smf30arl(124, 2),
        smf30arn(126, 2),
        smf30opo(128, 4),
        smf30opl(132, 2),
        smf30opn(134, 2),
        smf30opm(136, 4),
        smf30udo(140, 4),
        smf30udl(144, 2),
        smf30udn(146, 2),
        smf30uds(148, 4),
        smf30rmo(152, 4),
        smf30rml(156, 2),
        smf30rmn(158, 2),
        smf30rms(160, 4),
        smf30mof(164, 4),
        smf30mln(168, 2),
        smf30mno(170, 2),
        smf30mos(172, 4),
        smf30cdo(176, 4),
        smf30cdl(180, 2),
        smf30cdn(182, 2),
        smf30uso(184, 4),
        smf30usl(188, 2),
        smf30usn(190, 2),
        smf30cpo(192, 4),
        smf30cpl(196, 2),
        smf30cpn(198, 2),
        smf30cpa(200, 4),
        smf30npo(204, 4),
        smf30npl(208, 2),
        smf30npn(210, 2),
        smf30npa(212, 4),
        smf30ContRecsToFollow(216, 2),
        smf30RecContFlags(218, 1),
        smf30cno(220, 4),
        smf30cnl(224, 2),
        smf30cnn(226, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

