/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf41;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf41.Header;
import com.blackhillsoftware.smf.smf41.ObjectAccessDataSection;
import com.blackhillsoftware.smf.smf41.ObjectIoActivityDataSection;
import com.blackhillsoftware.smf.smf41.ObjectUnaccessDataSection;
import com.blackhillsoftware.smf.smf41.ProductSection;
import com.blackhillsoftware.smf.smf41.VlfStatisticsDataSection;
import java.util.List;

public class Smf41Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ObjectAccessDataSection> buildObjectAccessDataSection = new CreateSection<ObjectAccessDataSection>(){

        @Override
        public ObjectAccessDataSection createSection(byte[] data, int offset, int length) {
            return ObjectAccessDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ObjectIoActivityDataSection> buildObjectIoActivityDataSection = new CreateSection<ObjectIoActivityDataSection>(){

        @Override
        public ObjectIoActivityDataSection createSection(byte[] data, int offset, int length) {
            return ObjectIoActivityDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<ObjectUnaccessDataSection> buildObjectUnaccessDataSection = new CreateSection<ObjectUnaccessDataSection>(){

        @Override
        public ObjectUnaccessDataSection createSection(byte[] data, int offset, int length) {
            return ObjectUnaccessDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<VlfStatisticsDataSection> buildVlfStatisticsDataSection = new CreateSection<VlfStatisticsDataSection>(){

        @Override
        public VlfStatisticsDataSection createSection(byte[] data, int offset, int length) {
            return VlfStatisticsDataSection.create(data, offset, length);
        }
    };
    private List<ProductSection> m_productSections = null;
    private List<ObjectAccessDataSection> m_objectAccessDataSections = null;
    private List<ObjectIoActivityDataSection> m_objectIoActivityDataSections = null;
    private List<ObjectUnaccessDataSection> m_objectUnaccessDataSections = null;
    private List<VlfStatisticsDataSection> m_vlfStatisticsDataSections = null;
    private Header m_header = null;

    public Smf41Record(byte[] data) {
        super(data);
        if (this.recordType() != 41) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf41Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 41) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf41Record from(SmfRecord record) {
        return new Smf41Record(record);
    }

    public static Smf41Record from(byte[] data) {
        return new Smf41Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, tempHeader.smf41opd());
        }
        return this.m_header;
    }

    public List<ProductSection> productSections() {
        this.m_productSections = Util.sectionsFromTriplet(this.m_productSections, this.data, Triplets.ProductSection.getTriplet(this.header()), buildProductSection);
        return this.m_productSections;
    }

    public List<ObjectAccessDataSection> objectAccessDataSections() {
        this.m_objectAccessDataSections = Util.sectionsFromTriplet(this.m_objectAccessDataSections, this.data, Triplets.ObjectAccessDataSection.getTriplet(this.header()), buildObjectAccessDataSection);
        return this.m_objectAccessDataSections;
    }

    public List<ObjectIoActivityDataSection> objectIoActivityDataSections() {
        this.m_objectIoActivityDataSections = Util.sectionsFromTriplet(this.m_objectIoActivityDataSections, this.data, Triplets.ObjectIoActivityDataSection.getTriplet(this.header()), buildObjectIoActivityDataSection);
        return this.m_objectIoActivityDataSections;
    }

    public List<ObjectUnaccessDataSection> objectUnaccessDataSections() {
        this.m_objectUnaccessDataSections = Util.sectionsFromTriplet(this.m_objectUnaccessDataSections, this.data, Triplets.ObjectUnaccessDataSection.getTriplet(this.header()), buildObjectUnaccessDataSection);
        return this.m_objectUnaccessDataSections;
    }

    public List<VlfStatisticsDataSection> vlfStatisticsDataSections() {
        this.m_vlfStatisticsDataSections = Util.sectionsFromTriplet(this.m_vlfStatisticsDataSections, this.data, Triplets.VlfStatisticsDataSection.getTriplet(this.header()), buildVlfStatisticsDataSection);
        return this.m_vlfStatisticsDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf41opd(), header.smf41lpd(), header.smf41npd());
            }
        }
        ,
        ObjectAccessDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf41od1(), header.smf41ld1(), header.smf41nd1());
            }
        }
        ,
        ObjectIoActivityDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf41od3(), header.smf41ld3(), header.smf41nd3());
            }
        }
        ,
        ObjectUnaccessDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf41od2(), header.smf41ld2(), header.smf41nd2());
            }
        }
        ,
        VlfStatisticsDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf41od4(), header.smf41ld4(), header.smf41nd4());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

