/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf41;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class VlfStatisticsDataSection
extends SmfData {
    private VlfStatisticsDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf41cls() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long smf41mvt() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf41usd() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf41src() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf41fnd() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf41add() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf41del() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf41trm() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf41lrg() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public ZonedDateTime smf41tim() {
        return Util.Binary8xStckTime(this.data, 40);
    }

    public BigInteger smf41timRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public Duration smf41aag() {
        return Util.Binary4_Seconds(this.data, 48);
    }

    public double smf41aagSeconds() {
        return Util.ToSeconds(this.smf41aag());
    }

    public long smf41aagRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public Duration smf41yag() {
        return Util.Binary4_Seconds(this.data, 52);
    }

    public double smf41yagSeconds() {
        return Util.ToSeconds(this.smf41yag());
    }

    public long smf41yagRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration smf41mag() {
        return Util.Binary4_Seconds(this.data, 56);
    }

    public double smf41magSeconds() {
        return Util.ToSeconds(this.smf41mag());
    }

    public long smf41magRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf41cag() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public static VlfStatisticsDataSection create(byte[] Data2, int offset, int length) {
        return new VlfStatisticsDataSection(Data2, offset, length);
    }

    static enum Field {
        smf41cls(0, 8),
        smf41mvt(8, 4),
        smf41usd(12, 4),
        smf41src(16, 4),
        smf41fnd(20, 4),
        smf41add(24, 4),
        smf41del(28, 4),
        smf41trm(32, 4),
        smf41lrg(36, 4),
        smf41tim(40, 8),
        smf41aag(48, 4),
        smf41yag(52, 4),
        smf41mag(56, 4),
        smf41cag(60, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

