/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    public static final int SMF42PLN = 40;
    public static final int SMF42PVR = 1;
    public static final int SMF42PRD_LEN = 40;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf42pdl() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf42pdn() {
        return Util.ConvertEbcdic(this.data, 8, 10);
    }

    public int smf42psv() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public ZonedDateTime smf42pts() {
        return Util.Binary8xStckTime(this.data, 20);
    }

    public BigInteger smf42ptsRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 20);
    }

    public ZonedDateTime smf42pte() {
        return Util.Binary8xStckTime(this.data, 28);
    }

    public BigInteger smf42pteRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf42pdl(0, 8),
        smf42pdn(8, 10),
        smf42psv(18, 1),
        smf42pts(20, 8),
        smf42pte(28, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

