/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype11;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class XrcVolumeData
extends SmfData {
    public static final int S42XRVLD_LEN = 52;

    private XrcVolumeData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int s42xrvlx() {
        return Util.ConvertSignedBinary4(this.data, 0);
    }

    public String s42xrvlv() {
        return Util.ConvertEbcdic(this.data, 4, 6);
    }

    public String s42xrvav() {
        return Util.ConvertEbcdic(this.data, 10, 6);
    }

    public String s42xrvps() {
        return Util.ConvertEbcdic(this.data, 16, 1);
    }

    public int s42xrvss() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public long s42xrvpr() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long s42xrvwd() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long s42xrvnd() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long s42xrvfw() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long s42xrvuw() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long s42xrvrs() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long s42xrvrw() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public static XrcVolumeData create(byte[] Data2, int offset, int length) {
        return new XrcVolumeData(Data2, offset, length);
    }

    static enum Field {
        s42xrvlx(0, 4),
        s42xrvlv(4, 6),
        s42xrvav(10, 6),
        s42xrvps(16, 1),
        s42xrvss(18, 2),
        s42xrvpr(20, 4),
        s42xrvwd(24, 4),
        s42xrvnd(28, 4),
        s42xrvfw(32, 4),
        s42xrvuw(36, 4),
        s42xrvrs(40, 4),
        s42xrvrw(44, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

