/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class DatasetCfSysSummaryBelowBar
extends SmfData {
    public static final int SMF42GBI0 = Integer.MIN_VALUE;
    public static final int SMF42GBI1 = 0x40000000;
    public static final int SMF42G1C_LEN = 168;
    public static final int SMF42G1D_LEN = 168;
    public static final int SMF42G1B_LEN = 336;
    public static final int SMF42G1F_LEN = 168;
    public static final int SMF42G1G_LEN = 168;
    public static final int SMF42G1H_LEN = 168;
    public static final int SMF42G1I_LEN = 168;
    public static final int SMF42G1E_LEN = 672;
    public static final int SMF42GX6_LEN = 128;
    public static final int SMF42FX8_LEN = 64;
    public static final int SMF420GB_LEN = 1504;

    private DatasetCfSysSummaryBelowBar(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf42gba() {
        return Util.Binary4_Seconds(this.data, 0);
    }

    public double smf42gbaSeconds() {
        return Util.ToSeconds(this.smf42gba());
    }

    public long smf42gbaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String smf42gbb() {
        return Util.ConvertEbcdic(this.data, 16, 44);
    }

    public String smf42gbc() {
        return Util.ConvertEbcdic(this.data, 64, 44);
    }

    public int smf42gbd() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public String smf42gbe() {
        if (this.data.length >= 114 + this.smf42gbd()) {
            return Util.ConvertEbcdic(this.data, 114, this.smf42gbd());
        }
        return null;
    }

    public int smf42a08() {
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public String smf42gbf() {
        if (this.data.length >= 146 + this.smf42a08()) {
            return Util.ConvertEbcdic(this.data, 146, this.smf42a08());
        }
        return null;
    }

    public String smf42gbg() {
        return Util.ConvertEbcdic(this.data, 178, 30);
    }

    public String smf42gbh() {
        return Util.ConvertEbcdic(this.data, 208, 8);
    }

    public long smf42gbi() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public boolean smf42gbi0() {
        return Util.ConvertFlag(this.data, this.smf42gbi(), Integer.MIN_VALUE);
    }

    public boolean smf42gbi1() {
        return Util.ConvertFlag(this.data, this.smf42gbi(), 0x40000000L);
    }

    public String smf42a09() {
        return Util.ConvertEbcdic(this.data, 228, 12);
    }

    public long smf42gbk() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long smf42gbl() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long smf42gbm() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public int smf42gz8() {
        return Util.ConvertUnsignedBinary2(this.data, 252);
    }

    public int smf42gz9() {
        return Util.ConvertUnsignedBinary2(this.data, 254);
    }

    public String smf42gbn() {
        return Util.ConvertEbcdic(this.data, 256, 8);
    }

    public String smf42gbo() {
        return Util.ConvertEbcdic(this.data, 264, 8);
    }

    public String smf42gbp() {
        return Util.ConvertEbcdic(this.data, 272, 16);
    }

    public long smf42gia() {
        return Util.ConvertUnsignedBinary4(this.data, 288);
    }

    public long smf42gib() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public long smf42gic() {
        return Util.ConvertUnsignedBinary4(this.data, 296);
    }

    public long smf42gid() {
        return Util.ConvertUnsignedBinary4(this.data, 300);
    }

    public long smf42gie() {
        return Util.ConvertUnsignedBinary4(this.data, 304);
    }

    public long smf42gif() {
        return Util.ConvertUnsignedBinary4(this.data, 308);
    }

    public long smf42gig() {
        return Util.ConvertUnsignedBinary4(this.data, 312);
    }

    public long smf42gih() {
        return Util.ConvertUnsignedBinary4(this.data, 316);
    }

    public long smf42gii() {
        return Util.ConvertUnsignedBinary4(this.data, 320);
    }

    public long smf42gij() {
        return Util.ConvertUnsignedBinary4(this.data, 324);
    }

    public long smf42gik() {
        return Util.ConvertUnsignedBinary4(this.data, 328);
    }

    public long smf42gil() {
        return Util.ConvertUnsignedBinary4(this.data, 332);
    }

    public long smf42gim() {
        return Util.ConvertUnsignedBinary4(this.data, 336);
    }

    public long smf42gin() {
        return Util.ConvertUnsignedBinary4(this.data, 340);
    }

    public long smf42gio() {
        return Util.ConvertUnsignedBinary4(this.data, 344);
    }

    public long smf42gip() {
        return Util.ConvertUnsignedBinary4(this.data, 348);
    }

    public long smf42giq() {
        return Util.ConvertUnsignedBinary8(this.data, 352);
    }

    public BigInteger smf42giqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public long smf42gir() {
        return Util.ConvertUnsignedBinary4(this.data, 360);
    }

    public long smf42gis() {
        return Util.ConvertUnsignedBinary4(this.data, 364);
    }

    public long smf42git() {
        return Util.ConvertUnsignedBinary8(this.data, 368);
    }

    public BigInteger smf42gitAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 368);
    }

    public long smf42giu() {
        return Util.ConvertUnsignedBinary8(this.data, 376);
    }

    public BigInteger smf42giuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 376);
    }

    public Duration smf42giw() {
        return Util.Binary8MSSeconds(this.data, 400);
    }

    public double smf42giwSeconds() {
        return Util.ToSeconds(this.smf42giw());
    }

    public BigInteger smf42giwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 400);
    }

    public Duration smf42gix() {
        return Util.Binary4MS(this.data, 408);
    }

    public double smf42gixSeconds() {
        return Util.ToSeconds(this.smf42gix());
    }

    public long smf42gixRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 408);
    }

    public Duration smf42giy() {
        return Util.Binary4MS(this.data, 412);
    }

    public double smf42giySeconds() {
        return Util.ToSeconds(this.smf42giy());
    }

    public long smf42giyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 412);
    }

    public long smf42gja() {
        return Util.ConvertUnsignedBinary4(this.data, 456);
    }

    public long smf42gjb() {
        return Util.ConvertUnsignedBinary4(this.data, 460);
    }

    public long smf42gjc() {
        return Util.ConvertUnsignedBinary4(this.data, 464);
    }

    public long smf42gjd() {
        return Util.ConvertUnsignedBinary4(this.data, 468);
    }

    public long smf42gje() {
        return Util.ConvertUnsignedBinary4(this.data, 472);
    }

    public long smf42gjf() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public long smf42gjg() {
        return Util.ConvertUnsignedBinary4(this.data, 480);
    }

    public long smf42gjh() {
        return Util.ConvertUnsignedBinary4(this.data, 484);
    }

    public long smf42gji() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public long smf42gjj() {
        return Util.ConvertUnsignedBinary4(this.data, 492);
    }

    public long smf42gjk() {
        return Util.ConvertUnsignedBinary4(this.data, 496);
    }

    public long smf42gjl() {
        return Util.ConvertUnsignedBinary4(this.data, 500);
    }

    public long smf42gjm() {
        return Util.ConvertUnsignedBinary4(this.data, 504);
    }

    public long smf42gjn() {
        return Util.ConvertUnsignedBinary4(this.data, 508);
    }

    public long smf42gjo() {
        return Util.ConvertUnsignedBinary4(this.data, 512);
    }

    public long smf42gjp() {
        return Util.ConvertUnsignedBinary4(this.data, 516);
    }

    public long smf42gjq() {
        return Util.ConvertUnsignedBinary8(this.data, 520);
    }

    public BigInteger smf42gjqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 520);
    }

    public long smf42gjr() {
        return Util.ConvertUnsignedBinary4(this.data, 528);
    }

    public long smf42gjs() {
        return Util.ConvertUnsignedBinary4(this.data, 532);
    }

    public long smf42gjt() {
        return Util.ConvertUnsignedBinary8(this.data, 536);
    }

    public BigInteger smf42gjtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 536);
    }

    public long smf42gju() {
        return Util.ConvertUnsignedBinary8(this.data, 544);
    }

    public BigInteger smf42gjuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 544);
    }

    public Duration smf42gjw() {
        return Util.Binary8MSSeconds(this.data, 568);
    }

    public double smf42gjwSeconds() {
        return Util.ToSeconds(this.smf42gjw());
    }

    public BigInteger smf42gjwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 568);
    }

    public Duration smf42gjx() {
        return Util.Binary4MS(this.data, 576);
    }

    public double smf42gjxSeconds() {
        return Util.ToSeconds(this.smf42gjx());
    }

    public long smf42gjxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 576);
    }

    public Duration smf42gjy() {
        return Util.Binary4MS(this.data, 580);
    }

    public double smf42gjySeconds() {
        return Util.ToSeconds(this.smf42gjy());
    }

    public long smf42gjyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 580);
    }

    public long smf42gka() {
        return Util.ConvertUnsignedBinary4(this.data, 624);
    }

    public long smf42gkb() {
        return Util.ConvertUnsignedBinary4(this.data, 628);
    }

    public long smf42gkc() {
        return Util.ConvertUnsignedBinary4(this.data, 632);
    }

    public long smf42gkd() {
        return Util.ConvertUnsignedBinary4(this.data, 636);
    }

    public long smf42gke() {
        return Util.ConvertUnsignedBinary4(this.data, 640);
    }

    public long smf42gkf() {
        return Util.ConvertUnsignedBinary4(this.data, 644);
    }

    public long smf42gkg() {
        return Util.ConvertUnsignedBinary4(this.data, 648);
    }

    public long smf42gkh() {
        return Util.ConvertUnsignedBinary4(this.data, 652);
    }

    public long smf42gki() {
        return Util.ConvertUnsignedBinary4(this.data, 656);
    }

    public long smf42gkj() {
        return Util.ConvertUnsignedBinary4(this.data, 660);
    }

    public long smf42gkk() {
        return Util.ConvertUnsignedBinary4(this.data, 664);
    }

    public long smf42gkl() {
        return Util.ConvertUnsignedBinary4(this.data, 668);
    }

    public long smf42gkm() {
        return Util.ConvertUnsignedBinary4(this.data, 672);
    }

    public long smf42gkn() {
        return Util.ConvertUnsignedBinary4(this.data, 676);
    }

    public long smf42gko() {
        return Util.ConvertUnsignedBinary4(this.data, 680);
    }

    public long smf42gkp() {
        return Util.ConvertUnsignedBinary4(this.data, 684);
    }

    public long smf42gkq() {
        return Util.ConvertUnsignedBinary8(this.data, 688);
    }

    public BigInteger smf42gkqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 688);
    }

    public long smf42gkr() {
        return Util.ConvertUnsignedBinary4(this.data, 696);
    }

    public long smf42gks() {
        return Util.ConvertUnsignedBinary4(this.data, 700);
    }

    public long smf42gkt() {
        return Util.ConvertUnsignedBinary8(this.data, 704);
    }

    public BigInteger smf42gktAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 704);
    }

    public long smf42gku() {
        return Util.ConvertUnsignedBinary8(this.data, 712);
    }

    public BigInteger smf42gkuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 712);
    }

    public Duration smf42gkw() {
        return Util.Binary8MSSeconds(this.data, 736);
    }

    public double smf42gkwSeconds() {
        return Util.ToSeconds(this.smf42gkw());
    }

    public BigInteger smf42gkwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 736);
    }

    public Duration smf42gkx() {
        return Util.Binary4MS(this.data, 744);
    }

    public double smf42gkxSeconds() {
        return Util.ToSeconds(this.smf42gkx());
    }

    public long smf42gkxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 744);
    }

    public Duration smf42gky() {
        return Util.Binary4MS(this.data, 748);
    }

    public double smf42gkySeconds() {
        return Util.ToSeconds(this.smf42gky());
    }

    public long smf42gkyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 748);
    }

    public long smf42gla() {
        return Util.ConvertUnsignedBinary4(this.data, 792);
    }

    public long smf42glb() {
        return Util.ConvertUnsignedBinary4(this.data, 796);
    }

    public long smf42glc() {
        return Util.ConvertUnsignedBinary4(this.data, 800);
    }

    public long smf42gld() {
        return Util.ConvertUnsignedBinary4(this.data, 804);
    }

    public long smf42gle() {
        return Util.ConvertUnsignedBinary4(this.data, 808);
    }

    public long smf42glf() {
        return Util.ConvertUnsignedBinary4(this.data, 812);
    }

    public long smf42glg() {
        return Util.ConvertUnsignedBinary4(this.data, 816);
    }

    public long smf42glh() {
        return Util.ConvertUnsignedBinary4(this.data, 820);
    }

    public long smf42gli() {
        return Util.ConvertUnsignedBinary4(this.data, 824);
    }

    public long smf42glj() {
        return Util.ConvertUnsignedBinary4(this.data, 828);
    }

    public long smf42glk() {
        return Util.ConvertUnsignedBinary4(this.data, 832);
    }

    public long smf42gll() {
        return Util.ConvertUnsignedBinary4(this.data, 836);
    }

    public long smf42glm() {
        return Util.ConvertUnsignedBinary4(this.data, 840);
    }

    public long smf42gln() {
        return Util.ConvertUnsignedBinary4(this.data, 844);
    }

    public long smf42glo() {
        return Util.ConvertUnsignedBinary4(this.data, 848);
    }

    public long smf42glp() {
        return Util.ConvertUnsignedBinary4(this.data, 852);
    }

    public long smf42glq() {
        return Util.ConvertUnsignedBinary8(this.data, 856);
    }

    public BigInteger smf42glqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 856);
    }

    public long smf42glr() {
        return Util.ConvertUnsignedBinary4(this.data, 864);
    }

    public long smf42gls() {
        return Util.ConvertUnsignedBinary4(this.data, 868);
    }

    public long smf42glt() {
        return Util.ConvertUnsignedBinary8(this.data, 872);
    }

    public BigInteger smf42gltAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 872);
    }

    public long smf42glu() {
        return Util.ConvertUnsignedBinary8(this.data, 880);
    }

    public BigInteger smf42gluAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 880);
    }

    public Duration smf42glw() {
        return Util.Binary8MSSeconds(this.data, 904);
    }

    public double smf42glwSeconds() {
        return Util.ToSeconds(this.smf42glw());
    }

    public BigInteger smf42glwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 904);
    }

    public Duration smf42glx() {
        return Util.Binary4MS(this.data, 912);
    }

    public double smf42glxSeconds() {
        return Util.ToSeconds(this.smf42glx());
    }

    public long smf42glxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 912);
    }

    public Duration smf42gly() {
        return Util.Binary4MS(this.data, 916);
    }

    public double smf42glySeconds() {
        return Util.ToSeconds(this.smf42gly());
    }

    public long smf42glyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 916);
    }

    public long smf42gma() {
        return Util.ConvertUnsignedBinary4(this.data, 960);
    }

    public long smf42gmb() {
        return Util.ConvertUnsignedBinary4(this.data, 964);
    }

    public long smf42gmc() {
        return Util.ConvertUnsignedBinary4(this.data, 968);
    }

    public long smf42gmd() {
        return Util.ConvertUnsignedBinary4(this.data, 972);
    }

    public long smf42gme() {
        return Util.ConvertUnsignedBinary4(this.data, 976);
    }

    public long smf42gmf() {
        return Util.ConvertUnsignedBinary4(this.data, 980);
    }

    public long smf42gmg() {
        return Util.ConvertUnsignedBinary4(this.data, 984);
    }

    public long smf42gmh() {
        return Util.ConvertUnsignedBinary4(this.data, 988);
    }

    public long smf42gmi() {
        return Util.ConvertUnsignedBinary4(this.data, 992);
    }

    public long smf42gmj() {
        return Util.ConvertUnsignedBinary4(this.data, 996);
    }

    public long smf42gmk() {
        return Util.ConvertUnsignedBinary4(this.data, 1000);
    }

    public long smf42gml() {
        return Util.ConvertUnsignedBinary4(this.data, 1004);
    }

    public long smf42gmm() {
        return Util.ConvertUnsignedBinary4(this.data, 1008);
    }

    public long smf42gmn() {
        return Util.ConvertUnsignedBinary4(this.data, 1012);
    }

    public long smf42gmo() {
        return Util.ConvertUnsignedBinary4(this.data, 1016);
    }

    public long smf42gmp() {
        return Util.ConvertUnsignedBinary4(this.data, 1020);
    }

    public long smf42gmq() {
        return Util.ConvertUnsignedBinary8(this.data, 1024);
    }

    public BigInteger smf42gmqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1024);
    }

    public long smf42gmr() {
        return Util.ConvertUnsignedBinary4(this.data, 1032);
    }

    public long smf42gms() {
        return Util.ConvertUnsignedBinary4(this.data, 1036);
    }

    public long smf42gmt() {
        return Util.ConvertUnsignedBinary8(this.data, 1040);
    }

    public BigInteger smf42gmtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1040);
    }

    public long smf42gmu() {
        return Util.ConvertUnsignedBinary8(this.data, 1048);
    }

    public BigInteger smf42gmuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1048);
    }

    public Duration smf42gmw() {
        return Util.Binary8MSSeconds(this.data, 1072);
    }

    public double smf42gmwSeconds() {
        return Util.ToSeconds(this.smf42gmw());
    }

    public BigInteger smf42gmwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1072);
    }

    public Duration smf42gmx() {
        return Util.Binary4MS(this.data, 1080);
    }

    public double smf42gmxSeconds() {
        return Util.ToSeconds(this.smf42gmx());
    }

    public long smf42gmxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1080);
    }

    public Duration smf42gmy() {
        return Util.Binary4MS(this.data, 1084);
    }

    public double smf42gmySeconds() {
        return Util.ToSeconds(this.smf42gmy());
    }

    public long smf42gmyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1084);
    }

    public long smf42gna() {
        return Util.ConvertUnsignedBinary4(this.data, 1128);
    }

    public long smf42gnb() {
        return Util.ConvertUnsignedBinary4(this.data, 1132);
    }

    public long smf42gnc() {
        return Util.ConvertUnsignedBinary4(this.data, 1136);
    }

    public long smf42gnd() {
        return Util.ConvertUnsignedBinary4(this.data, 1140);
    }

    public long smf42gne() {
        return Util.ConvertUnsignedBinary4(this.data, 1144);
    }

    public long smf42gnf() {
        return Util.ConvertUnsignedBinary4(this.data, 1148);
    }

    public long smf42gng() {
        return Util.ConvertUnsignedBinary4(this.data, 1152);
    }

    public long smf42gnh() {
        return Util.ConvertUnsignedBinary4(this.data, 1156);
    }

    public long smf42gni() {
        return Util.ConvertUnsignedBinary4(this.data, 1160);
    }

    public long smf42gnj() {
        return Util.ConvertUnsignedBinary4(this.data, 1164);
    }

    public long smf42gnk() {
        return Util.ConvertUnsignedBinary4(this.data, 1168);
    }

    public long smf42gnl() {
        return Util.ConvertUnsignedBinary4(this.data, 1172);
    }

    public long smf42gnm() {
        return Util.ConvertUnsignedBinary4(this.data, 1176);
    }

    public long smf42gnn() {
        return Util.ConvertUnsignedBinary4(this.data, 1180);
    }

    public long smf42gno() {
        return Util.ConvertUnsignedBinary4(this.data, 1184);
    }

    public long smf42gnp() {
        return Util.ConvertUnsignedBinary4(this.data, 1188);
    }

    public long smf42gnq() {
        return Util.ConvertUnsignedBinary8(this.data, 1192);
    }

    public BigInteger smf42gnqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1192);
    }

    public long smf42gnr() {
        return Util.ConvertUnsignedBinary4(this.data, 1200);
    }

    public long smf42gns() {
        return Util.ConvertUnsignedBinary4(this.data, 1204);
    }

    public long smf42gnt() {
        return Util.ConvertUnsignedBinary8(this.data, 1208);
    }

    public BigInteger smf42gntAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1208);
    }

    public long smf42gnu() {
        return Util.ConvertUnsignedBinary8(this.data, 1216);
    }

    public BigInteger smf42gnuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1216);
    }

    public Duration smf42gnw() {
        return Util.Binary8MSSeconds(this.data, 1240);
    }

    public double smf42gnwSeconds() {
        return Util.ToSeconds(this.smf42gnw());
    }

    public BigInteger smf42gnwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1240);
    }

    public Duration smf42gnx() {
        return Util.Binary4MS(this.data, 1248);
    }

    public double smf42gnxSeconds() {
        return Util.ToSeconds(this.smf42gnx());
    }

    public long smf42gnxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1248);
    }

    public Duration smf42gny() {
        return Util.Binary4MS(this.data, 1252);
    }

    public double smf42gnySeconds() {
        return Util.ToSeconds(this.smf42gny());
    }

    public long smf42gnyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1252);
    }

    public String smf42gx6() {
        return Util.ConvertEbcdic(this.data, 1296, 128);
    }

    public long smf42gqa() {
        return Util.ConvertUnsignedBinary4(this.data, 1296);
    }

    public long smf42gqb() {
        return Util.ConvertUnsignedBinary4(this.data, 1300);
    }

    public long smf42gqc() {
        return Util.ConvertUnsignedBinary4(this.data, 1304);
    }

    public long smf42gqd() {
        return Util.ConvertUnsignedBinary4(this.data, 1308);
    }

    public long smf42gqe() {
        return Util.ConvertUnsignedBinary4(this.data, 1312);
    }

    public long smf42gqf() {
        return Util.ConvertUnsignedBinary4(this.data, 1316);
    }

    public long smf42gva() {
        return Util.ConvertUnsignedBinary4(this.data, 1320);
    }

    public long smf42gvb() {
        return Util.ConvertUnsignedBinary4(this.data, 1324);
    }

    public long smf42gqh() {
        return Util.ConvertUnsignedBinary4(this.data, 1328);
    }

    public long smf42gqi() {
        return Util.ConvertUnsignedBinary4(this.data, 1332);
    }

    public long smf42gqj() {
        return Util.ConvertUnsignedBinary4(this.data, 1336);
    }

    public long smf42gqk() {
        return Util.ConvertUnsignedBinary4(this.data, 1340);
    }

    public long smf42gql() {
        return Util.ConvertUnsignedBinary4(this.data, 1344);
    }

    public long smf42gqm() {
        return Util.ConvertUnsignedBinary4(this.data, 1348);
    }

    public long smf42gqn() {
        return Util.ConvertUnsignedBinary4(this.data, 1352);
    }

    public long smf42gqo() {
        return Util.ConvertUnsignedBinary4(this.data, 1356);
    }

    public long smf42gqp() {
        return Util.ConvertUnsignedBinary4(this.data, 1360);
    }

    public long smf42gqq() {
        return Util.ConvertUnsignedBinary4(this.data, 1364);
    }

    public long smf42gqr() {
        return Util.ConvertUnsignedBinary4(this.data, 1368);
    }

    public long smf42gqs() {
        return Util.ConvertUnsignedBinary4(this.data, 1372);
    }

    public long smf42gqt() {
        return Util.ConvertUnsignedBinary4(this.data, 1376);
    }

    public long smf42gqu() {
        return Util.ConvertUnsignedBinary4(this.data, 1380);
    }

    public long smf42gqv() {
        return Util.ConvertUnsignedBinary4(this.data, 1384);
    }

    public long smf42gqw() {
        return Util.ConvertUnsignedBinary4(this.data, 1388);
    }

    public long smf42gvd() {
        return Util.ConvertUnsignedBinary4(this.data, 1392);
    }

    public long smf42gve() {
        return Util.ConvertUnsignedBinary4(this.data, 1396);
    }

    public long smf42gvf() {
        return Util.ConvertUnsignedBinary4(this.data, 1400);
    }

    public long smf42gvg() {
        return Util.ConvertUnsignedBinary4(this.data, 1404);
    }

    public long smf42gth() {
        return Util.ConvertUnsignedBinary4(this.data, 1408);
    }

    public long smf42gti() {
        return Util.ConvertUnsignedBinary4(this.data, 1412);
    }

    public long smf42gtj() {
        return Util.ConvertUnsignedBinary4(this.data, 1416);
    }

    public long smf42gtk() {
        return Util.ConvertUnsignedBinary4(this.data, 1420);
    }

    public long smf42grl() {
        return Util.ConvertUnsignedBinary4(this.data, 1424);
    }

    public long smf42grm() {
        return Util.ConvertUnsignedBinary4(this.data, 1428);
    }

    public long smf42grn() {
        return Util.ConvertUnsignedBinary4(this.data, 1432);
    }

    public long smf42gro() {
        return Util.ConvertUnsignedBinary4(this.data, 1436);
    }

    public long smf42grp() {
        return Util.ConvertUnsignedBinary4(this.data, 1440);
    }

    public long smf42grr() {
        return Util.ConvertUnsignedBinary4(this.data, 1444);
    }

    public long smf42grs() {
        return Util.ConvertUnsignedBinary4(this.data, 1448);
    }

    public long smf42grt() {
        return Util.ConvertUnsignedBinary4(this.data, 1452);
    }

    public long smf42gru() {
        return Util.ConvertUnsignedBinary4(this.data, 1468);
    }

    public long smf42gta() {
        return Util.ConvertUnsignedBinary4(this.data, 1472);
    }

    public long smf42gtb() {
        return Util.ConvertUnsignedBinary4(this.data, 1476);
    }

    public String smf42gbq() {
        return Util.ConvertEbcdic(this.data, 1488, 16);
    }

    public static DatasetCfSysSummaryBelowBar create(byte[] Data2, int offset, int length) {
        return new DatasetCfSysSummaryBelowBar(Data2, offset, length);
    }

    static enum Field {
        smf42gba(0, 4),
        smf42gbb(16, 44),
        smf42gbc(64, 44),
        smf42gbd(112, 2),
        smf42gbe(114, 0),
        smf42a08(144, 2),
        smf42gbf(146, 0),
        smf42gbg(178, 30),
        smf42gbh(208, 8),
        smf42gbi(224, 4),
        smf42a09(228, 12),
        smf42gbk(240, 4),
        smf42gbl(244, 4),
        smf42gbm(248, 4),
        smf42gz8(252, 2),
        smf42gz9(254, 2),
        smf42gbn(256, 8),
        smf42gbo(264, 8),
        smf42gbp(272, 16),
        smf42gia(288, 4),
        smf42gib(292, 4),
        smf42gic(296, 4),
        smf42gid(300, 4),
        smf42gie(304, 4),
        smf42gif(308, 4),
        smf42gig(312, 4),
        smf42gih(316, 4),
        smf42gii(320, 4),
        smf42gij(324, 4),
        smf42gik(328, 4),
        smf42gil(332, 4),
        smf42gim(336, 4),
        smf42gin(340, 4),
        smf42gio(344, 4),
        smf42gip(348, 4),
        smf42giq(352, 8),
        smf42gir(360, 4),
        smf42gis(364, 4),
        smf42git(368, 8),
        smf42giu(376, 8),
        smf42giw(400, 8),
        smf42gix(408, 4),
        smf42giy(412, 4),
        smf42gja(456, 4),
        smf42gjb(460, 4),
        smf42gjc(464, 4),
        smf42gjd(468, 4),
        smf42gje(472, 4),
        smf42gjf(476, 4),
        smf42gjg(480, 4),
        smf42gjh(484, 4),
        smf42gji(488, 4),
        smf42gjj(492, 4),
        smf42gjk(496, 4),
        smf42gjl(500, 4),
        smf42gjm(504, 4),
        smf42gjn(508, 4),
        smf42gjo(512, 4),
        smf42gjp(516, 4),
        smf42gjq(520, 8),
        smf42gjr(528, 4),
        smf42gjs(532, 4),
        smf42gjt(536, 8),
        smf42gju(544, 8),
        smf42gjw(568, 8),
        smf42gjx(576, 4),
        smf42gjy(580, 4),
        smf42gka(624, 4),
        smf42gkb(628, 4),
        smf42gkc(632, 4),
        smf42gkd(636, 4),
        smf42gke(640, 4),
        smf42gkf(644, 4),
        smf42gkg(648, 4),
        smf42gkh(652, 4),
        smf42gki(656, 4),
        smf42gkj(660, 4),
        smf42gkk(664, 4),
        smf42gkl(668, 4),
        smf42gkm(672, 4),
        smf42gkn(676, 4),
        smf42gko(680, 4),
        smf42gkp(684, 4),
        smf42gkq(688, 8),
        smf42gkr(696, 4),
        smf42gks(700, 4),
        smf42gkt(704, 8),
        smf42gku(712, 8),
        smf42gkw(736, 8),
        smf42gkx(744, 4),
        smf42gky(748, 4),
        smf42gla(792, 4),
        smf42glb(796, 4),
        smf42glc(800, 4),
        smf42gld(804, 4),
        smf42gle(808, 4),
        smf42glf(812, 4),
        smf42glg(816, 4),
        smf42glh(820, 4),
        smf42gli(824, 4),
        smf42glj(828, 4),
        smf42glk(832, 4),
        smf42gll(836, 4),
        smf42glm(840, 4),
        smf42gln(844, 4),
        smf42glo(848, 4),
        smf42glp(852, 4),
        smf42glq(856, 8),
        smf42glr(864, 4),
        smf42gls(868, 4),
        smf42glt(872, 8),
        smf42glu(880, 8),
        smf42glw(904, 8),
        smf42glx(912, 4),
        smf42gly(916, 4),
        smf42gma(960, 4),
        smf42gmb(964, 4),
        smf42gmc(968, 4),
        smf42gmd(972, 4),
        smf42gme(976, 4),
        smf42gmf(980, 4),
        smf42gmg(984, 4),
        smf42gmh(988, 4),
        smf42gmi(992, 4),
        smf42gmj(996, 4),
        smf42gmk(1000, 4),
        smf42gml(1004, 4),
        smf42gmm(1008, 4),
        smf42gmn(1012, 4),
        smf42gmo(1016, 4),
        smf42gmp(1020, 4),
        smf42gmq(1024, 8),
        smf42gmr(1032, 4),
        smf42gms(1036, 4),
        smf42gmt(1040, 8),
        smf42gmu(1048, 8),
        smf42gmw(1072, 8),
        smf42gmx(1080, 4),
        smf42gmy(1084, 4),
        smf42gna(1128, 4),
        smf42gnb(1132, 4),
        smf42gnc(1136, 4),
        smf42gnd(1140, 4),
        smf42gne(1144, 4),
        smf42gnf(1148, 4),
        smf42gng(1152, 4),
        smf42gnh(1156, 4),
        smf42gni(1160, 4),
        smf42gnj(1164, 4),
        smf42gnk(1168, 4),
        smf42gnl(1172, 4),
        smf42gnm(1176, 4),
        smf42gnn(1180, 4),
        smf42gno(1184, 4),
        smf42gnp(1188, 4),
        smf42gnq(1192, 8),
        smf42gnr(1200, 4),
        smf42gns(1204, 4),
        smf42gnt(1208, 8),
        smf42gnu(1216, 8),
        smf42gnw(1240, 8),
        smf42gnx(1248, 4),
        smf42gny(1252, 4),
        smf42gx6(1296, 128),
        smf42gqa(1296, 4),
        smf42gqb(1300, 4),
        smf42gqc(1304, 4),
        smf42gqd(1308, 4),
        smf42gqe(1312, 4),
        smf42gqf(1316, 4),
        smf42gva(1320, 4),
        smf42gvb(1324, 4),
        smf42gqh(1328, 4),
        smf42gqi(1332, 4),
        smf42gqj(1336, 4),
        smf42gqk(1340, 4),
        smf42gql(1344, 4),
        smf42gqm(1348, 4),
        smf42gqn(1352, 4),
        smf42gqo(1356, 4),
        smf42gqp(1360, 4),
        smf42gqq(1364, 4),
        smf42gqr(1368, 4),
        smf42gqs(1372, 4),
        smf42gqt(1376, 4),
        smf42gqu(1380, 4),
        smf42gqv(1384, 4),
        smf42gqw(1388, 4),
        smf42gvd(1392, 4),
        smf42gve(1396, 4),
        smf42gvf(1400, 4),
        smf42gvg(1404, 4),
        smf42gth(1408, 4),
        smf42gti(1412, 4),
        smf42gtj(1416, 4),
        smf42gtk(1420, 4),
        smf42grl(1424, 4),
        smf42grm(1428, 4),
        smf42grn(1432, 4),
        smf42gro(1436, 4),
        smf42grp(1440, 4),
        smf42grr(1444, 4),
        smf42grs(1448, 4),
        smf42grt(1452, 4),
        smf42gru(1468, 4),
        smf42gta(1472, 4),
        smf42gtb(1476, 4),
        smf42gbq(1488, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

