/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype4;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf42.subtype4.ConcurrentCopySsidHeader;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.List;

public final class ConcurrentCopySessionStatistics
extends SmfData {
    public static final int SMF4204C_LEN = 64;
    private List<ConcurrentCopySsidHeader> m_concurrentCopySsidHeader = null;

    private ConcurrentCopySessionStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long s42ccid() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String s42ccrqs() {
        return Util.ConvertEbcdic(this.data, 4, 2);
    }

    public String s42ccts() {
        return Util.ConvertEbcdic(this.data, 6, 1);
    }

    public String s42ccjnm() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String s42ccjno() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public ZonedDateTime s42ccsst() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger s42ccsstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public ZonedDateTime s42cceit() {
        return Util.Binary8xStckTime(this.data, 32);
    }

    public BigInteger s42cceitRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public ZonedDateTime s42ccset() {
        return Util.Binary8xStckTime(this.data, 40);
    }

    public BigInteger s42ccsetRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public int s42ccsso() {
        return Util.ConvertSignedBinary4(this.data, 48);
    }

    public int s42ccssn() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int s42ccssl() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public List<ConcurrentCopySsidHeader> ConcurrentCopySsidHeaders() {
        this.m_concurrentCopySsidHeader = Util.sectionsFromTriplet(this.m_concurrentCopySsidHeader, this.data, () -> this.s42ccsso(), () -> this.s42ccssl(), () -> this.s42ccssn(), ConcurrentCopySsidHeader::create);
        return this.m_concurrentCopySsidHeader;
    }

    public static ConcurrentCopySessionStatistics create(byte[] Data2, int offset, int length) {
        return new ConcurrentCopySessionStatistics(Data2, offset, length);
    }

    static enum Field {
        s42ccid(0, 4),
        s42ccrqs(4, 2),
        s42ccts(6, 1),
        s42ccjnm(8, 8),
        s42ccjno(16, 8),
        s42ccsst(24, 8),
        s42cceit(32, 8),
        s42ccset(40, 8),
        s42ccsso(48, 4),
        s42ccssn(52, 2),
        s42ccssl(54, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

