/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype6;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf42.subtype6.AccessMethodStatistics;
import com.blackhillsoftware.smf.smf42.subtype6.DatasetIoStatistics;
import com.blackhillsoftware.smf.smf42.subtype6.S42Dstype;
import com.blackhillsoftware.smf.smf42.subtype6.SynchronousIoStatistics;
import com.blackhillsoftware.smf.smf42.subtype6.SynchronousIoStatistics2;
import com.blackhillsoftware.smf.smf42.subtype6.SynchronousIoStatistics3;

public final class DatasetHeader
extends SmfData {
    public static final int S42FIRST = 128;
    public static final int S42DSVBU = 192;
    public static final int S42DSGSR = 192;
    public static final int S42DSLSR = 128;
    public static final int S42DSRLS = 64;
    public static final int S42DSNSR = 0;
    public static final int S42DSENC = 32;
    public static final int S42DSEXC = 16;
    public static final int S42DSFXD = 8;
    public static final int S42DSPL = 4;
    public static final int S42DSEF = 2;
    public static final int S42DSEFC = 1;
    public static final int S42DSAES256 = 256;
    public static final int S42DSCNO = 0;
    public static final int S42DSCGE = 1;
    public static final int S42DSCTL = 2;
    public static final int S42DSCZE = 3;
    private DatasetIoStatistics m_DatasetIoStatistics = null;
    private AccessMethodStatistics m_AccessMethodStatistics = null;
    private SynchronousIoStatistics m_SynchronousIoStatistics = null;
    private SynchronousIoStatistics2 m_SynchronousIoStatistics2 = null;
    private SynchronousIoStatistics3 m_SynchronousIoStatistics3 = null;
    public static final int S42DS2DL = 128;
    public static final int S42DS2MV = 64;
    public static final int S42DSH_LEN = 112;

    private DatasetHeader(byte[] Data2, int offset, int length, int dsioLength, int dsamLength) {
        super(Data2, offset, length);
        if (this.s42dsioo() != 0) {
            this.m_DatasetIoStatistics = DatasetIoStatistics.create(Data2, this.s42dsioo(), dsioLength);
        }
        if (this.s42dsamo() != 0) {
            this.m_AccessMethodStatistics = AccessMethodStatistics.create(Data2, this.s42dsamo(), dsamLength);
        }
        if (length > Field.s42dssnl.offset + Field.s42dssnl.length && this.s42dssno() != 0) {
            this.m_SynchronousIoStatistics = SynchronousIoStatistics.create(Data2, this.s42dssno(), this.s42dssnl());
        }
        if (length > Field.s42dss2l.offset + Field.s42dss2l.length && this.s42dss2o() != 0) {
            this.m_SynchronousIoStatistics2 = SynchronousIoStatistics2.create(Data2, this.s42dss2o(), this.s42dss2l());
        }
        if (length > Field.s42dss3l.offset + Field.s42dss3l.length && this.s42dss3o() != 0) {
            this.m_SynchronousIoStatistics3 = SynchronousIoStatistics3.create(Data2, this.s42dss3o(), this.s42dss3l());
        }
    }

    public int s42dsnxt() {
        return Util.ConvertSignedBinary4(this.data, 0);
    }

    public String s42dsn() {
        return Util.ConvertEbcdic(this.data, 4, 44);
    }

    public S42Dstype s42dstyp() {
        return S42Dstype.forDstypeId(Util.ConvertUnsignedBinary1(this.data, 48));
    }

    public int s42dstypRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int s42dscod() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean s42first() {
        return Util.ConvertFlag(this.data, this.s42dscod(), 128);
    }

    public int s42dsfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public boolean s42dsgsr() {
        return Util.ConvertEquateValue(this.data, this.s42dsfl1(), 192, 192);
    }

    public boolean s42dslsr() {
        return Util.ConvertEquateValue(this.data, this.s42dsfl1(), 128, 192);
    }

    public boolean s42dsrls() {
        return Util.ConvertEquateValue(this.data, this.s42dsfl1(), 64, 192);
    }

    public boolean s42dsnsr() {
        return Util.ConvertEquateValue(this.data, this.s42dsfl1(), 0, 192);
    }

    public boolean s42dsenc() {
        return Util.ConvertFlag(this.data, this.s42dsfl1(), 32);
    }

    public boolean s42dsexc() {
        return Util.ConvertFlag(this.data, this.s42dsfl1(), 16);
    }

    public boolean s42dsfxd() {
        return Util.ConvertFlag(this.data, this.s42dsfl1(), 8);
    }

    public boolean s42dspl() {
        return Util.ConvertFlag(this.data, this.s42dsfl1(), 4);
    }

    public boolean s42dsef() {
        return Util.ConvertFlag(this.data, this.s42dsfl1(), 2);
    }

    public boolean s42dsefc() {
        return Util.ConvertFlag(this.data, this.s42dsfl1(), 1);
    }

    public int s42dsioo() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int s42dsamo() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public String s42dsvol() {
        return Util.ConvertEbcdic(this.data, 60, 6);
    }

    public int s42dsdev() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public String s42dssc() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public long s42dsbsz() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public int s42dstrp() {
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int s42dsent() {
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int s42dscmt() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    public int s42dssno() {
        return Util.ConvertSignedBinary4(this.data, 88);
    }

    public int s42dssnl() {
        return Util.ConvertUnsignedBinary2(this.data, 92);
    }

    public int s42dss2o() {
        return Util.ConvertSignedBinary4(this.data, 96);
    }

    public int s42dss2l() {
        return Util.ConvertUnsignedBinary2(this.data, 100);
    }

    public int s42ds2fl() {
        return Util.ConvertUnsignedBinary1(this.data, 102);
    }

    public boolean s42ds2dl() {
        return Util.ConvertFlag(this.data, this.s42ds2fl(), 128);
    }

    public boolean s42ds2mv() {
        return Util.ConvertFlag(this.data, this.s42ds2fl(), 64);
    }

    public int s42dss3o() {
        return Util.ConvertSignedBinary4(this.data, 104);
    }

    public int s42dss3l() {
        return Util.ConvertUnsignedBinary2(this.data, 108);
    }

    public DatasetIoStatistics datasetIoStatistics() {
        return this.m_DatasetIoStatistics;
    }

    public AccessMethodStatistics accessMethodIoStatistics() {
        return this.m_AccessMethodStatistics;
    }

    public SynchronousIoStatistics synchronousIoStatistics() {
        return this.m_SynchronousIoStatistics;
    }

    public SynchronousIoStatistics2 synchronousIoStatistics2() {
        return this.m_SynchronousIoStatistics2;
    }

    public SynchronousIoStatistics3 synchronousIoStatistics3() {
        return this.m_SynchronousIoStatistics3;
    }

    public static DatasetHeader create(byte[] Data2, int offset, int length, int dsioLength, int dsamLength) {
        return new DatasetHeader(Data2, offset, length, dsioLength, dsamLength);
    }

    static enum Field {
        s42dsnxt(0, 4),
        s42dsn(4, 44),
        s42dstyp(48, 1),
        s42dscod(49, 1),
        s42dsfl1(50, 1),
        s42dsioo(52, 4),
        s42dsamo(56, 4),
        s42dsvol(60, 6),
        s42dsdev(66, 2),
        s42dssc(68, 8),
        s42dsbsz(76, 4),
        s42dstrp(80, 2),
        s42dsent(82, 2),
        s42dscmt(84, 1),
        s42dssno(88, 4),
        s42dssnl(92, 2),
        s42dss2o(96, 4),
        s42dss2l(100, 2),
        s42ds2fl(102, 1),
        s42dss3o(104, 4),
        s42dss3l(108, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

