/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype9;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.dataset.Disp;
import com.blackhillsoftware.smf.dataset.Dsorg;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class BDE37AbendData
extends SmfData {
    public static final int S42B37 = 128;
    public static final int S42D37 = 64;
    public static final int S42E37 = 32;
    public static final int SMF4209A_LEN = 108;

    private BDE37AbendData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String s42asyid() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public String s42jobn() {
        return Util.ConvertEbcdic(this.data, 4, 8);
    }

    public LocalTime s42rdst() {
        return Util.Binary4x100STime(this.data, 12);
    }

    public long s42rdstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public LocalDate s42rdsd() {
        return Util.SMFDate(this.data, 16);
    }

    public int s42rdsdRawValue() {
        return Util.ConvertPacked4(this.data, 16);
    }

    public String s42aauid() {
        return Util.ConvertEbcdic(this.data, 20, 8);
    }

    public int s42astpn() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public int s42flags() {
        return Util.ConvertUnsignedBinary1(this.data, 29);
    }

    public boolean s42b37() {
        return Util.ConvertFlag(this.data, this.s42flags(), 128);
    }

    public boolean s42d37() {
        return Util.ConvertFlag(this.data, this.s42flags(), 64);
    }

    public boolean s42e37() {
        return Util.ConvertFlag(this.data, this.s42flags(), 32);
    }

    public Dsorg s42dsorg() {
        return Dsorg.fromDsorgBytes(Util.ConvertUnsignedBinary2(this.data, 34));
    }

    public Disp s42adisp() {
        return Disp.from(Util.ConvertUnsignedBinary1(this.data, 36) & 0xC0);
    }

    public String s42dsnme() {
        return Util.ConvertEbcdic(this.data, 37, 44);
    }

    public String s42volsr() {
        return Util.ConvertEbcdic(this.data, 81, 6);
    }

    public long s42ucbtp() {
        return Util.ConvertUnsignedBinary4(this.data, 87);
    }

    public int s42next() {
        return Util.ConvertUnsignedBinary1(this.data, 91);
    }

    public long s42tntrk() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long s42assat() {
        return this.s42assatRawValue() & 0xFFFFFFL;
    }

    private long s42assatRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public String s42assatUnit() {
        long bits = this.s42assatRawValue() >> 24 & 0xC0L;
        if (bits == 0L) {
            return null;
        }
        if (bits == 192L) {
            return "CYL";
        }
        if (bits == 128L) {
            return "TRK";
        }
        if (bits == 64L) {
            return "AVGREC";
        }
        return "NOT DEFINED";
    }

    public int s42adrlh() {
        return Util.ConvertUnsignedBinary3(this.data, 100);
    }

    public static BDE37AbendData create(byte[] Data2, int offset, int length) {
        return new BDE37AbendData(Data2, offset, length);
    }

    static enum Field {
        s42asyid(0, 4),
        s42jobn(4, 8),
        s42rdst(12, 4),
        s42rdsd(16, 4),
        s42aauid(20, 8),
        s42astpn(28, 1),
        s42flags(29, 1),
        s42dsorg(34, 2),
        s42adisp(36, 1),
        s42dsnme(37, 44),
        s42volsr(81, 6),
        s42ucbtp(87, 4),
        s42next(91, 1),
        s42tntrk(92, 4),
        s42assat(96, 4),
        s42adrlh(100, 3);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

