/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf6;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf6.Smf6Subsystem;

public final class IoDataSection
extends SmfData {
    private Smf6Subsystem subsystem;
    public static final int SMF6DCRV = 128;
    public static final int SMF6SDS = 64;
    public static final int SMF6OCN = 32;
    public static final int SMF6ORD = 16;
    public static final int SMF6OR = 8;
    public static final int SMF6ROR = 4;
    public static final int SMF6OSS = 2;
    public static final int SMF6INT = 1;
    public static final int SMF6LEV2 = 1;
    public static final int SMF6J2L3 = 3;
    public static final int SMF6J2L4 = 4;
    public static final int SMF6LEV3 = 1;
    public static final int SMF6J3L3 = 3;
    public static final int SMF6J3L4 = 4;
    public static final int SMF6LEV4 = 5;
    public static final int SMF6LEV6 = 6;
    public static final int SMF6LEV7 = 7;
    public static final int SMF6J2S = 92;
    public static final int SMF6J3S = 92;
    public static final int SMF6CCE = 2;
    public static final int SMF6RBE = 1;

    private IoDataSection(byte[] Data2, int offset, int length, Smf6Subsystem smf6Subsystem) {
        super(Data2, offset, length);
        this.subsystem = smf6Subsystem;
    }

    public int smf6ln1() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf6dci() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf6dcrv() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 128);
    }

    public boolean smf6sds() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 64);
    }

    public boolean smf6ocn() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 32);
    }

    public boolean smf6ord() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 16);
    }

    public boolean smf6or() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 8);
    }

    public boolean smf6ror() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 4);
    }

    public boolean smf6oss() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 2);
    }

    public boolean smf6int() {
        return Util.ConvertFlag(this.data, this.smf6dci(), 1);
    }

    public int smf6indc() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public String smf6jnm() {
        if (this.smf6indc() != 1) {
            throw new NotAvailableException("This method is only supported when smf6indc() == SMF6LEV2");
        }
        return Util.ConvertEbcdic(this.data, 4, 4);
    }

    public String smf6out() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String smf6fcb() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public String smf6ucs() {
        return Util.ConvertEbcdic(this.data, 20, 4);
    }

    public long smf6pge() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf6rte() {
        if (this.subsystem != Smf6Subsystem.jes2) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf6dfe() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public boolean smf6cce() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertFlag(this.data, this.smf6dfe(), 2);
    }

    public boolean smf6rbe() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertFlag(this.data, this.smf6dfe(), 1);
    }

    public int smf6opr() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public String smf6grp() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf6rsvj() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String smf6rsvu() {
        if (this.subsystem != Smf6Subsystem.jes3) {
            throw new NotAvailableException("This method is only supported when smf6sbs() == 5");
        }
        return Util.ConvertEbcdic(this.data, 48, 4);
    }

    public static IoDataSection create(byte[] Data2, int offset, int length, Smf6Subsystem smf6Subsystem) {
        return new IoDataSection(Data2, offset, length, smf6Subsystem);
    }

    static enum Field {
        smf6ln1(0, 2),
        smf6dci(2, 1),
        smf6indc(3, 1),
        smf6jnm(4, 4),
        smf6out(8, 8),
        smf6fcb(16, 4),
        smf6ucs(20, 4),
        smf6pge(24, 4),
        smf6rte(28, 2),
        smf6dfe(28, 2),
        smf6opr(30, 2),
        smf6grp(32, 8),
        smf6rsvj(40, 8),
        smf6rsvu(48, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

