/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf60;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf60.EntryType;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf60Record
extends SmfRecord {
    public static final int SMF60SLF = 24;
    public static final int SMF60PRD = 40;
    public static final int SMF60DAT = 50;

    public Smf60Record(byte[] data) {
        super(data);
        this.checkRecord();
    }

    public Smf60Record(SmfRecord record) {
        super(record);
        this.checkRecord();
    }

    public static Smf60Record from(SmfRecord record) {
        return new Smf60Record(record);
    }

    public static Smf60Record from(byte[] data) {
        return new Smf60Record(data);
    }

    private void checkRecord() {
        if (this.recordType() != 60) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        if (this.smf60pno() > 1) {
            throw new IllegalArgumentException("Multiple product sections found: " + Integer.toString(this.smf60pno()));
        }
        if (this.smf60dno() > 1) {
            throw new IllegalArgumentException("Multiple data sections found: " + Integer.toString(this.smf60dno()));
        }
    }

    public int smf60len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf60seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf60sys() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf60rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf60tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf60tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf60dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf60dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf60cpu() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf60sub() {
        return Util.ConvertEbcdic(this.data, 22, 2);
    }

    public int smf60pof() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int smf60pln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf60pno() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smf60dof() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int smf60dln() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smf60dno() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String smf60ver() {
        return Util.ConvertEbcdic(this.data, 40, 2);
    }

    public String smf60pnm() {
        return Util.ConvertEbcdic(this.data, 42, 8);
    }

    public String smf60jnm() {
        return Util.ConvertEbcdic(this.data, 50, 8);
    }

    public LocalTime smf60rst() {
        return Util.Binary4x100STime(this.data, 58);
    }

    public long smf60rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 58);
    }

    public LocalDate smf60rdt() {
        return Util.SMFDate(this.data, 62);
    }

    public int smf60rdtRawValue() {
        return Util.ConvertPacked4(this.data, 62);
    }

    public String smf60uid() {
        return Util.ConvertEbcdic(this.data, 66, 8);
    }

    public String smf60fnc() {
        return Util.ConvertEbcdic(this.data, 74, 1);
    }

    public String smf60cnm() {
        return Util.ConvertEbcdic(this.data, 75, 44);
    }

    public int smf60typ() {
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public EntryType smf60EntryType() {
        return EntryType.fromInt(this.smf60typ());
    }

    public String smf60enm() {
        return Util.ConvertEbcdic(this.data, 120, 44);
    }

    private int smf60crcl() {
        return Util.ConvertUnsignedBinary2(this.data, Field.smf60crc.offset);
    }

    public byte[] smf60crc() {
        if (this.data.length >= Field.smf60crc.offset + this.smf60crcl()) {
            byte[] result = new byte[this.smf60crcl()];
            System.arraycopy(this.data, Field.smf60crc.offset, result, 0, this.smf60crcl());
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(Field.smf60crc.offset) + " Data length: " + Integer.toString(this.smf60crcl()));
    }

    static enum Field {
        smf60len(0, 2),
        smf60seg(2, 2),
        smf60sys(4, 1),
        smf60rty(5, 1),
        smf60tme(6, 4),
        smf60dte(10, 4),
        smf60cpu(14, 4),
        smf60sub(22, 2),
        smf60pof(24, 4),
        smf60pln(28, 2),
        smf60pno(30, 2),
        smf60dof(32, 4),
        smf60dln(36, 2),
        smf60dno(38, 2),
        smf60ver(40, 2),
        smf60pnm(42, 8),
        smf60jnm(50, 8),
        smf60rst(58, 4),
        smf60rdt(62, 4),
        smf60uid(66, 8),
        smf60fnc(74, 1),
        smf60cnm(75, 44),
        smf60typ(119, 1),
        smf60enm(120, 44),
        smf60crc(208, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

