/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf64;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;

public final class StatisticsSection
extends SmfData {
    public static final int SMF64ACC = 128;
    public static final int SMF64SYS = 64;
    public static final int SMF64DO = 32;
    public static final int SMF64SO = 16;
    public static final int SMF64SW = 8;
    public static final int SMF64DW = 4;
    public static final int SMF64CO = 2;
    public static final int SMF64CR = 1;
    public static final int SMF64VSP = 128;
    public static final int SMF64HWT = 64;
    public static final int SMF64BUF = 32;
    public static final int SMF64CB = 16;
    public static final int SMF64IVS = 8;
    public static final int SMF64RDC = 4;
    public static final int SMF64MIN = 2;
    public static final int SMF64HSP = 1;
    public static final int SMF64CKP = 128;
    public static final int SMF64EOV = 64;

    private StatisticsSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf64sln() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long smf64nil() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf64nex() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf64nlr() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf64nde() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf64nin() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf64nup() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf64nre() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf64nfs() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf64ncs() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf64nas() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf64nep() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf64dil() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf64dex() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf64dlr() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public long smf64dde() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf64din() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf64dup() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf64dre() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf64dfs() {
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public long smf64dcs() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf64das() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf64dep() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf64dbs() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf64dci() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smf64dls() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public int smf64dkl() {
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public String smf64ddn() {
        return Util.ConvertEbcdic(this.data, 106, 8);
    }

    public int smf64str() {
        return Util.ConvertUnsignedBinary1(this.data, 114);
    }

    public int smf64bno() {
        return Util.ConvertUnsignedBinary1(this.data, 115);
    }

    public long smf64bsp() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public int smf64bfd() {
        return Util.ConvertUnsignedBinary2(this.data, 120);
    }

    public int smf64bfi() {
        return Util.ConvertUnsignedBinary2(this.data, 122);
    }

    public String smf64cln() {
        return Util.ConvertEbcdic(this.data, 124, 44);
    }

    public int smf64plh() {
        return Util.ConvertUnsignedBinary2(this.data, 168);
    }

    public long smf64mac() {
        return Util.ConvertUnsignedBinary4(this.data, 170);
    }

    public int smf64mc1() {
        return Util.ConvertUnsignedBinary1(this.data, 170);
    }

    public int smf64mc2() {
        return Util.ConvertUnsignedBinary1(this.data, 171);
    }

    public int smf64mc3() {
        return Util.ConvertUnsignedBinary1(this.data, 172);
    }

    public int smf64mc4() {
        return Util.ConvertUnsignedBinary1(this.data, 173);
    }

    public int smf64smb() {
        return Util.ConvertUnsignedBinary1(this.data, 174);
    }

    public boolean smf64acc() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 128);
    }

    public boolean smf64sys() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 64);
    }

    public boolean smf64do() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 32);
    }

    public boolean smf64so() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 16);
    }

    public boolean smf64sw() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 8);
    }

    public boolean smf64dw() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 4);
    }

    public boolean smf64co() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 2);
    }

    public boolean smf64cr() {
        return Util.ConvertFlag(this.data, this.smf64smb(), 1);
    }

    public int smf64rsc() {
        return Util.ConvertUnsignedBinary1(this.data, 175);
    }

    public boolean smf64vsp() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 128);
    }

    public boolean smf64hwt() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 64);
    }

    public boolean smf64buf() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 32);
    }

    public boolean smf64cb() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 16);
    }

    public boolean smf64ivs() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 8);
    }

    public boolean smf64rdc() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 4);
    }

    public boolean smf64min() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 2);
    }

    public boolean smf64hsp() {
        return Util.ConvertFlag(this.data, this.smf64rsc(), 1);
    }

    public long smf64sio() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long smf64hit() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long smf64wts() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long smf64mis() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long smf64ios() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long smf64sds() {
        return Util.ConvertUnsignedBinary8(this.data, 196);
    }

    public BigInteger smf64sdsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public long smf64cds() {
        return Util.ConvertUnsignedBinary8(this.data, 204);
    }

    public BigInteger smf64cdsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 204);
    }

    public long smf64css() {
        return Util.ConvertUnsignedBinary8(this.data, 212);
    }

    public BigInteger smf64cssAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 212);
    }

    public long smf64ccs() {
        return Util.ConvertUnsignedBinary8(this.data, 220);
    }

    public BigInteger smf64ccsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 220);
    }

    public byte[] smf64dtk() {
        if (this.data.length >= 264) {
            byte[] result = new byte[36];
            System.arraycopy(this.data, 228, result, 0, 36);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(228) + " Data length: " + Integer.toString(36));
    }

    public long smf64trk() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long smf64bmh() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public long smf64cfh() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long smf64rio() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public LocalTime smf64tim() {
        return Util.Binary4x100STime(this.data, 280);
    }

    public long smf64timRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public LocalDate smf64dt() {
        return Util.SMFDate(this.data, 284);
    }

    public int smf64dtRawValue() {
        return Util.ConvertPacked4(this.data, 284);
    }

    public int smf64fg1() {
        return Util.ConvertUnsignedBinary1(this.data, 288);
    }

    public boolean smf64ckp() {
        return Util.ConvertFlag(this.data, this.smf64fg1(), 128);
    }

    public boolean smf64eov() {
        return Util.ConvertFlag(this.data, this.smf64fg1(), 64);
    }

    public int smf64fd1() {
        return Util.ConvertUnsignedBinary1(this.data, 289);
    }

    public int smf64fd2() {
        return Util.ConvertUnsignedBinary1(this.data, 290);
    }

    public long smf64dau() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public long smf64rlm() {
        return Util.ConvertUnsignedBinary4(this.data, 296);
    }

    public long smf64nta() {
        return Util.ConvertUnsignedBinary4(this.data, 300);
    }

    public static StatisticsSection create(byte[] Data2, int offset, int length) {
        return new StatisticsSection(Data2, offset, length);
    }

    static enum Field {
        smf64sln(0, 4),
        smf64nil(4, 4),
        smf64nex(8, 4),
        smf64nlr(12, 4),
        smf64nde(16, 4),
        smf64nin(20, 4),
        smf64nup(24, 4),
        smf64nre(28, 4),
        smf64nfs(32, 4),
        smf64ncs(36, 4),
        smf64nas(40, 4),
        smf64nep(44, 4),
        smf64dil(48, 4),
        smf64dex(52, 4),
        smf64dlr(56, 4),
        smf64dde(60, 4),
        smf64din(64, 4),
        smf64dup(68, 4),
        smf64dre(72, 4),
        smf64dfs(76, 4),
        smf64dcs(80, 4),
        smf64das(84, 4),
        smf64dep(88, 4),
        smf64dbs(92, 4),
        smf64dci(96, 4),
        smf64dls(100, 4),
        smf64dkl(104, 2),
        smf64ddn(106, 8),
        smf64str(114, 1),
        smf64bno(115, 1),
        smf64bsp(116, 4),
        smf64bfd(120, 2),
        smf64bfi(122, 2),
        smf64cln(124, 44),
        smf64plh(168, 2),
        smf64mac(170, 4),
        smf64mc1(170, 1),
        smf64mc2(171, 1),
        smf64mc3(172, 1),
        smf64mc4(173, 1),
        smf64smb(174, 1),
        smf64rsc(175, 1),
        smf64sio(176, 4),
        smf64hit(180, 4),
        smf64wts(184, 4),
        smf64mis(188, 4),
        smf64ios(192, 4),
        smf64sds(196, 8),
        smf64cds(204, 8),
        smf64css(212, 8),
        smf64ccs(220, 8),
        smf64dtk(228, 36),
        smf64trk(264, 4),
        smf64bmh(268, 4),
        smf64cfh(272, 4),
        smf64rio(276, 4),
        smf64tim(280, 4),
        smf64dt(284, 4),
        smf64fg1(288, 1),
        smf64fd1(289, 1),
        smf64fd2(290, 1),
        smf64dau(292, 4),
        smf64rlm(296, 4),
        smf64nta(300, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

