/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf70.Header;
import com.blackhillsoftware.smf.smf70.ProductSection;
import com.blackhillsoftware.smf.smf70.subtype1.AsidDataAreaSection;
import com.blackhillsoftware.smf.smf70.subtype1.CpuControlSection;
import com.blackhillsoftware.smf.smf70.subtype1.CpuDataSection;
import com.blackhillsoftware.smf.smf70.subtype1.CpuIdentificationSection;
import com.blackhillsoftware.smf.smf70.subtype1.LogicalCoreDataSection;
import com.blackhillsoftware.smf.smf70.subtype1.PrismLogicalProcessorDataSection;
import com.blackhillsoftware.smf.smf70.subtype1.PrismPartitionDataSection;
import com.blackhillsoftware.smf.smf70.subtype1.TenantResourceGroupDataSection;
import com.blackhillsoftware.smf.smf70.subtype2.CryptographicAcceleratorDataSection;
import com.blackhillsoftware.smf.smf70.subtype2.CryptographicCcaCoprocessorDataSection;
import com.blackhillsoftware.smf.smf70.subtype2.CryptographicPkcs11CoprocessorDataSection;
import com.blackhillsoftware.smf.smf70.subtype2.IcsfServicesDataSection;
import java.util.List;

public final class Smf70Record
extends SmfRecord {
    private static final CreateSection<ProductSection> buildProductSection = new CreateSection<ProductSection>(){

        @Override
        public ProductSection createSection(byte[] data, int offset, int length) {
            return ProductSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CpuControlSection> buildCpuControlSection = new CreateSection<CpuControlSection>(){

        @Override
        public CpuControlSection createSection(byte[] data, int offset, int length) {
            return CpuControlSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CpuDataSection> buildCpuDataSection = new CreateSection<CpuDataSection>(){

        @Override
        public CpuDataSection createSection(byte[] data, int offset, int length) {
            return CpuDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<AsidDataAreaSection> buildAsidDataAreaSection = new CreateSection<AsidDataAreaSection>(){

        @Override
        public AsidDataAreaSection createSection(byte[] data, int offset, int length) {
            return AsidDataAreaSection.create(data, offset, length);
        }
    };
    private static final CreateSection<PrismPartitionDataSection> buildPrismPartitionDataSection = new CreateSection<PrismPartitionDataSection>(){

        @Override
        public PrismPartitionDataSection createSection(byte[] data, int offset, int length) {
            return PrismPartitionDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<PrismLogicalProcessorDataSection> buildPrismLogicalProcessorDataSection = new CreateSection<PrismLogicalProcessorDataSection>(){

        @Override
        public PrismLogicalProcessorDataSection createSection(byte[] data, int offset, int length) {
            return PrismLogicalProcessorDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CpuIdentificationSection> buildCpuIdentificationSection = new CreateSection<CpuIdentificationSection>(){

        @Override
        public CpuIdentificationSection createSection(byte[] data, int offset, int length) {
            return CpuIdentificationSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CryptographicCcaCoprocessorDataSection> buildCryptographicCcaCoprocessorDataSection = new CreateSection<CryptographicCcaCoprocessorDataSection>(){

        @Override
        public CryptographicCcaCoprocessorDataSection createSection(byte[] data, int offset, int length) {
            return CryptographicCcaCoprocessorDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CryptographicAcceleratorDataSection> buildCryptographicAcceleratorDataSection = new CreateSection<CryptographicAcceleratorDataSection>(){

        @Override
        public CryptographicAcceleratorDataSection createSection(byte[] data, int offset, int length) {
            return CryptographicAcceleratorDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<IcsfServicesDataSection> buildIcsfServicesDataSection = new CreateSection<IcsfServicesDataSection>(){

        @Override
        public IcsfServicesDataSection createSection(byte[] data, int offset, int length) {
            return IcsfServicesDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<CryptographicPkcs11CoprocessorDataSection> buildCryptographicPkcs11CoprocessorDataSection = new CreateSection<CryptographicPkcs11CoprocessorDataSection>(){

        @Override
        public CryptographicPkcs11CoprocessorDataSection createSection(byte[] data, int offset, int length) {
            return CryptographicPkcs11CoprocessorDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<LogicalCoreDataSection> buildLogicalCoreDataSection = new CreateSection<LogicalCoreDataSection>(){

        @Override
        public LogicalCoreDataSection createSection(byte[] data, int offset, int length) {
            return LogicalCoreDataSection.create(data, offset, length);
        }
    };
    private static final CreateSection<TenantResourceGroupDataSection> buildTenantResourceGroupDataSection = new CreateSection<TenantResourceGroupDataSection>(){

        @Override
        public TenantResourceGroupDataSection createSection(byte[] data, int offset, int length) {
            return TenantResourceGroupDataSection.create(data, offset, length);
        }
    };
    private static final int TRIPLETLENGTH = 8;
    private List<CpuDataSection> m_cpuDataSections = null;
    private List<AsidDataAreaSection> m_asidDataAreaSections = null;
    private List<PrismPartitionDataSection> m_prismPartitionDataSections = null;
    private List<PrismLogicalProcessorDataSection> m_prismLogicalProcessorDataSections = null;
    private List<CpuIdentificationSection> m_cpuIdentificationSections = null;
    private List<LogicalCoreDataSection> m_logicalCoreDataSections = null;
    private List<TenantResourceGroupDataSection> m_tenantResourceGroupDataSections = null;
    private List<CryptographicCcaCoprocessorDataSection> m_cryptographicCcaCoprocessorDataSections = null;
    private List<CryptographicAcceleratorDataSection> m_cryptographicAcceleratorDataSections = null;
    private List<IcsfServicesDataSection> m_icsfServicesDataSections = null;
    private List<CryptographicPkcs11CoprocessorDataSection> m_cryptographicPkcs11CoprocessorDataSections = null;
    private Header m_header = null;
    private ProductSection m_productSection = null;
    private CpuControlSection m_cpuControlSection = null;

    public Smf70Record(byte[] data) {
        super(data);
        if (this.recordType() != 70) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf70Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 70) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf70Record from(SmfRecord record) {
        return new Smf70Record(record);
    }

    public static Smf70Record from(byte[] data) {
        return new Smf70Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, Header.Field.smf70prs.offset() + tempHeader.smf70trn() * 8);
        }
        return this.m_header;
    }

    public ProductSection productSection() {
        if (this.m_productSection == null) {
            Triplet t = Triplets.ProductSection.getTriplet(this.header());
            this.m_productSection = buildProductSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_productSection;
    }

    public CpuControlSection cpuControlSection() {
        if (this.m_cpuControlSection == null) {
            Triplet t = Triplets.CpuControlSection.getTriplet(this.header());
            this.m_cpuControlSection = buildCpuControlSection.createSection(this.data, t.getOffset(), t.getLength());
        }
        return this.m_cpuControlSection;
    }

    public List<CpuDataSection> cpuDataSections() {
        this.m_cpuDataSections = Util.sectionsFromTriplet(this.m_cpuDataSections, this.data, Triplets.CpuDataSection.getTriplet(this.header()), buildCpuDataSection);
        return this.m_cpuDataSections;
    }

    public List<AsidDataAreaSection> asidDataAreaSections() {
        this.m_asidDataAreaSections = Util.sectionsFromTriplet(this.m_asidDataAreaSections, this.data, Triplets.AsidDataAreaSection.getTriplet(this.header()), buildAsidDataAreaSection);
        return this.m_asidDataAreaSections;
    }

    public List<PrismPartitionDataSection> prismPartitionDataSections() {
        this.m_prismPartitionDataSections = Util.sectionsFromTriplet(this.m_prismPartitionDataSections, this.data, Triplets.PrismPartitionDataSection.getTriplet(this.header()), buildPrismPartitionDataSection);
        return this.m_prismPartitionDataSections;
    }

    public List<PrismLogicalProcessorDataSection> prismLogicalProcessorDataSections() {
        this.m_prismLogicalProcessorDataSections = Util.sectionsFromTriplet(this.m_prismLogicalProcessorDataSections, this.data, Triplets.PrismLogicalProcessorDataSection.getTriplet(this.header()), buildPrismLogicalProcessorDataSection);
        return this.m_prismLogicalProcessorDataSections;
    }

    public List<CpuIdentificationSection> cpuIdentificationSections() {
        this.m_cpuIdentificationSections = Util.sectionsFromTriplet(this.m_cpuIdentificationSections, this.data, Triplets.CpuIdentificationSection.getTriplet(this.header()), buildCpuIdentificationSection);
        return this.m_cpuIdentificationSections;
    }

    public List<LogicalCoreDataSection> logicalCoreDataSections() {
        this.m_logicalCoreDataSections = Util.sectionsFromTriplet(this.m_logicalCoreDataSections, this.data, Triplets.LogicalCoreDataSection.getTriplet(this.header()), buildLogicalCoreDataSection);
        return this.m_logicalCoreDataSections;
    }

    public List<TenantResourceGroupDataSection> tenantResourceGroupDataSections() {
        this.m_tenantResourceGroupDataSections = Util.sectionsFromTriplet(this.m_tenantResourceGroupDataSections, this.data, Triplets.TenantResourceGroupDataSection.getTriplet(this.header()), buildTenantResourceGroupDataSection);
        return this.m_tenantResourceGroupDataSections;
    }

    public List<CryptographicCcaCoprocessorDataSection> cryptographicCcaCoprocessorDataSections() {
        this.m_cryptographicCcaCoprocessorDataSections = Util.sectionsFromTriplet(this.m_cryptographicCcaCoprocessorDataSections, this.data, Triplets.CryptographicCcaCoprocessorDataSection.getTriplet(this.header()), buildCryptographicCcaCoprocessorDataSection);
        return this.m_cryptographicCcaCoprocessorDataSections;
    }

    public List<CryptographicAcceleratorDataSection> cryptographicAcceleratorDataSections() {
        this.m_cryptographicAcceleratorDataSections = Util.sectionsFromTriplet(this.m_cryptographicAcceleratorDataSections, this.data, Triplets.CryptographicAcceleratorDataSection.getTriplet(this.header()), buildCryptographicAcceleratorDataSection);
        return this.m_cryptographicAcceleratorDataSections;
    }

    public List<IcsfServicesDataSection> icsfServicesDataSections() {
        this.m_icsfServicesDataSections = Util.sectionsFromTriplet(this.m_icsfServicesDataSections, this.data, Triplets.IcsfServicesDataSection.getTriplet(this.header()), buildIcsfServicesDataSection);
        return this.m_icsfServicesDataSections;
    }

    public List<CryptographicPkcs11CoprocessorDataSection> cryptographicPkcs11CoprocessorDataSections() {
        this.m_cryptographicPkcs11CoprocessorDataSections = Util.sectionsFromTriplet(this.m_cryptographicPkcs11CoprocessorDataSections, this.data, Triplets.CryptographicPkcs11CoprocessorDataSection.getTriplet(this.header()), buildCryptographicPkcs11CoprocessorDataSection);
        return this.m_cryptographicPkcs11CoprocessorDataSections;
    }

    private static enum Triplets {
        ProductSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70prs(), header.smf70prl(), header.smf70prn());
            }
        }
        ,
        CpuControlSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70ccs(), header.smf70ccl(), header.smf70ccn());
            }
        }
        ,
        CpuDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70cps(), header.smf70cpl(), header.smf70cpn());
            }
        }
        ,
        AsidDataAreaSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70ass(), header.smf70asl(), header.smf70asn());
            }
        }
        ,
        PrismPartitionDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70bcs(), header.smf70bcl(), header.smf70bcn());
            }
        }
        ,
        PrismLogicalProcessorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70bvs(), header.smf70bvl(), header.smf70bvn());
            }
        }
        ,
        CpuIdentificationSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70cns(), header.smf70cnl(), header.smf70cnn());
            }
        }
        ,
        CryptographicCcaCoprocessorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf7023s(), header.smf7023l(), header.smf7023n());
            }
        }
        ,
        CryptographicAcceleratorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf7024s(), header.smf7024l(), header.smf7024n());
            }
        }
        ,
        IcsfServicesDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf702cs(), header.smf702cl(), header.smf702cn());
            }
        }
        ,
        CryptographicPkcs11CoprocessorDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf7025s(), header.smf7025l(), header.smf7025n());
            }
        }
        ,
        LogicalCoreDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70cos(), header.smf70col(), header.smf70con());
            }
        }
        ,
        TenantResourceGroupDataSection{

            @Override
            Triplet getTriplet(Header header) {
                return new Triplet(header.smf70tns(), header.smf70tnl(), header.smf70tnn());
            }
        };


        abstract Triplet getTriplet(Header var1);
    }
}

