/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype1;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class LogicalCoreDataSection
extends SmfData {
    public static final int SMF70_LPB_VALID = 128;

    private LogicalCoreDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf70CoreId() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf70CoreFlg() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf70LpbValid() {
        return Util.ConvertFlag(this.data, this.smf70CoreFlg(), 128);
    }

    public int smf70CpuSkip() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int smf70CpuNum() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public long smf70Prod() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public Duration smf70LparBusy() {
        if (!this.smf70LpbValid()) {
            throw new NotAvailableException("This method is only supported when smf70LpbValid() == true");
        }
        return Util.Binary4MS(this.data, 12);
    }

    public double smf70LparBusySeconds() {
        if (!this.smf70LpbValid()) {
            throw new NotAvailableException("This method is only supported when smf70LpbValid() == true");
        }
        return Util.ToSeconds(this.smf70LparBusy());
    }

    public long smf70LparBusyRawValue() {
        if (!this.smf70LpbValid()) {
            throw new NotAvailableException("This method is only supported when smf70LpbValid() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public static LogicalCoreDataSection create(byte[] Data2, int offset, int length) {
        return new LogicalCoreDataSection(Data2, offset, length);
    }

    static enum Field {
        smf70CoreId(0, 2),
        smf70CoreFlg(2, 1),
        smf70CpuSkip(4, 2),
        smf70CpuNum(6, 2),
        smf70Prod(8, 4),
        smf70LparBusy(12, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

