/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class PrismPartitionDataSection
extends SmfData {
    public static final int SMF70PDV = 128;
    public static final int SMF70NVC = 64;
    public static final int SMF70NDC = 32;
    public static final int SMF70NSC = 16;
    public static final int SMF70WLM = 8;
    public static final int SMF70WTF = 4;
    public static final int SMF70MSC = 2;
    public static final int SMF70MSF = 1;
    public static final int SMF70UVF = 32768;
    public static final int SMF70GRP = 16384;
    public static final int SMF70PWF = 8192;
    public static final int SMF70UIW = 4096;
    public static final int SMF70_BoostInfo_zIIP = 128;
    public static final int SMF70_BoostInfo_Speed = 64;

    private PrismPartitionDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf70lpm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public int smf70lpn() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf70pfg() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf70pdv() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 128);
    }

    public boolean smf70nvc() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 64);
    }

    public boolean smf70ndc() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 32);
    }

    public boolean smf70nsc() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 16);
    }

    public boolean smf70wlm() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 8);
    }

    public boolean smf70wtf() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 4);
    }

    public boolean smf70msc() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 2);
    }

    public boolean smf70msf() {
        return Util.ConvertFlag(this.data, this.smf70pfg(), 1);
    }

    public int smf70bdn() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public long smf70bds() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf70bda() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public String smf70spn() {
        return Util.ConvertEbcdic(this.data, 20, 8);
    }

    public String smf70stn() {
        return Util.ConvertEbcdic(this.data, 28, 8);
    }

    public long smf70csf() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf70esf() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf70msu() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public int smf70pfl() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public boolean smf70uvf() {
        return Util.ConvertFlag(this.data, this.smf70pfl(), 32768);
    }

    public boolean smf70grp() {
        return Util.ConvertFlag(this.data, this.smf70pfl(), 16384);
    }

    public boolean smf70pwf() {
        return Util.ConvertFlag(this.data, this.smf70pfl(), 8192);
    }

    public boolean smf70uiw() {
        return Util.ConvertFlag(this.data, this.smf70pfl(), 4096);
    }

    public int smf70upi() {
        return Util.ConvertUnsignedBinary1(this.data, 58);
    }

    public int smf70mtid() {
        return Util.ConvertUnsignedBinary1(this.data, 59);
    }

    public String smf70gnm() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    public long smf70gmu() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public String smf70hwgrName() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public int smf70BoostInfo() {
        return Util.ConvertUnsignedBinary1(this.data, 80);
    }

    public boolean smf70BoostInfoZiip() {
        return Util.ConvertFlag(this.data, this.smf70BoostInfo(), 128);
    }

    public boolean smf70BoostInfoSpeed() {
        return Util.ConvertFlag(this.data, this.smf70BoostInfo(), 64);
    }

    public static PrismPartitionDataSection create(byte[] Data2, int offset, int length) {
        return new PrismPartitionDataSection(Data2, offset, length);
    }

    static enum Field {
        smf70lpm(0, 8),
        smf70lpn(8, 1),
        smf70pfg(9, 1),
        smf70bdn(10, 2),
        smf70bds(12, 4),
        smf70bda(16, 4),
        smf70spn(20, 8),
        smf70stn(28, 8),
        smf70csf(40, 4),
        smf70esf(48, 4),
        smf70msu(52, 4),
        smf70pfl(56, 2),
        smf70upi(58, 1),
        smf70mtid(59, 1),
        smf70gnm(60, 8),
        smf70gmu(68, 4),
        smf70hwgrName(72, 8),
        smf70BoostInfo(80, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

