/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf73;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF73RRF = 128;
    public static final int SMF73SUT = 64;
    public static final int SMF73V4 = 16;
    public static final int SMF73ESA = 8;
    public static final int SMF73VXA = 4;
    public static final int SMF73OS = 2;
    public static final int SMF73BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf73len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf73seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf73flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf73rrf() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 128);
    }

    public boolean smf73sut() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 64);
    }

    public boolean smf73v4() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 16);
    }

    public boolean smf73esa() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 8);
    }

    public boolean smf73vxa() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 4);
    }

    public boolean smf73os() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 2);
    }

    public boolean smf73bfy() {
        return Util.ConvertFlag(this.data, this.smf73flg(), 1);
    }

    public int smf73rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf73tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf73tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf73dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf73dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf73sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf73ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf73sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf73trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf73prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf73prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf73prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf73his() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf73hil() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf73hin() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf73hps() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf73hpl() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf73hpn() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf73hes() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf73hel() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf73hen() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf73len(0, 2),
        smf73seg(2, 2),
        smf73flg(4, 1),
        smf73rty(5, 1),
        smf73tme(6, 4),
        smf73dte(10, 4),
        smf73sid(14, 4),
        smf73ssi(18, 4),
        smf73sty(22, 2),
        smf73trn(24, 2),
        smf73prs(28, 4),
        smf73prl(32, 2),
        smf73prn(34, 2),
        smf73his(36, 4),
        smf73hil(40, 2),
        smf73hin(42, 2),
        smf73hps(44, 4),
        smf73hpl(48, 2),
        smf73hpn(50, 2),
        smf73hes(52, 4),
        smf73hel(56, 2),
        smf73hen(58, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

