/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf73.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class ChannelPathControlSection
extends SmfData {
    public static final int SMF73DCA = 128;
    public static final int SMF73IAC = 64;
    public static final int SMF73IOD = 32;
    public static final int SMF73ICV = 16;
    public static final int SMF73REP = 8;
    public static final int SMF73CMF = 4;
    public static final int SMF73MCG = 2;
    public static final int SMF73CMC = 1;
    public static final int SMF73CMH = 128;
    public static final int SMF73CMD = 64;
    public static final int SMF73MCS = 32;
    public static final int SMF73ECM = 16;

    private ChannelPathControlSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf73smp() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int smf73cfl() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf73dca() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 128);
    }

    public boolean smf73iac() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 64);
    }

    public boolean smf73iod() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 32);
    }

    public boolean smf73icv() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 16);
    }

    public boolean smf73rep() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 8);
    }

    public boolean smf73cmf() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 4);
    }

    public boolean smf73mcg() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 2);
    }

    public boolean smf73cmc() {
        return Util.ConvertFlag(this.data, this.smf73cfl(), 1);
    }

    public int smf73sfl() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public boolean smf73cmh() {
        return Util.ConvertFlag(this.data, this.smf73sfl(), 128);
    }

    public boolean smf73cmd() {
        return Util.ConvertFlag(this.data, this.smf73sfl(), 64);
    }

    public boolean smf73mcs() {
        return Util.ConvertFlag(this.data, this.smf73sfl(), 32);
    }

    public boolean smf73ecm() {
        return Util.ConvertFlag(this.data, this.smf73sfl(), 16);
    }

    public String smf73tnm() {
        return Util.ConvertEbcdic(this.data, 8, 44);
    }

    public String smf73tsf() {
        return Util.ConvertEbcdic(this.data, 52, 2);
    }

    public String smf73tok() {
        return Util.ConvertEbcdic(this.data, 56, 16);
    }

    public LocalDate smf73tdt() {
        return Util.EBCDIC8mm_dd_yy(this.data, 56);
    }

    public String smf73tdtRawValue() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalTime smf73ttm() {
        return Util.EBCDIC8hh_mm_ss(this.data, 64);
    }

    public String smf73ttmRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public long smf73crc() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf73csc() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public LocalDate smf73tdy() {
        return Util.EBCDIC10mm_dd_yyyy(this.data, 80);
    }

    public String smf73tdyRawValue() {
        return Util.ConvertEbcdic(this.data, 80, 10);
    }

    public int smf73cmi() {
        return Util.ConvertUnsignedBinary1(this.data, 90);
    }

    public int smf73css() {
        return Util.ConvertUnsignedBinary1(this.data, 91);
    }

    public static ChannelPathControlSection create(byte[] Data2, int offset, int length) {
        return new ChannelPathControlSection(Data2, offset, length);
    }

    static enum Field {
        smf73smp(0, 4),
        smf73cfl(4, 1),
        smf73sfl(5, 1),
        smf73tnm(8, 44),
        smf73tsf(52, 2),
        smf73tok(56, 16),
        smf73tdt(56, 8),
        smf73ttm(64, 8),
        smf73crc(72, 4),
        smf73csc(76, 4),
        smf73tdy(80, 10),
        smf73cmi(90, 1),
        smf73css(91, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

