/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf73.subtype1;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class ChannelPathDataSection
extends SmfData {
    public static final int SMF73RV3 = 192;
    public static final int SMF73BL = 32;
    public static final int SMF73BY = 16;
    public static final int SMF73RV4 = 8;
    public static final int SMF73PAR = 4;
    public static final int SMF73VAC = 2;
    public static final int SMF73STA = 1;
    public static final int SMF73CNC = 128;
    public static final int SMF73DOC = 64;
    public static final int SMF73CVC = 32;
    public static final int SMF73MOD = 16;
    public static final int SMF73DEL = 8;
    public static final int SMF73INS = 4;
    public static final int SMF73VLD = 2;
    public static final int SMF73SHR = 1;
    public static final int SMF73NVL = 128;
    public static final int SMF73CC = 64;
    public static final int SMF73FXT = 32;
    public static final int SMF73CPM = 8;
    public static final int SMF73CDC = 4;
    public static final int SMF73XCM = 2;
    public static final int SMF73PNI = 1;
    public static final int SMF73WD1 = 128;
    public static final int SMF73WD2 = 64;
    public static final int SMF73WD3 = 32;
    public static final int SMF73WD4 = 16;
    public static final int SMF73WD5 = 8;

    private ChannelPathDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf73pid() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smf73fg2() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean smf73bl() {
        return Util.ConvertFlag(this.data, this.smf73fg2(), 32);
    }

    public boolean smf73by() {
        return Util.ConvertFlag(this.data, this.smf73fg2(), 16);
    }

    public boolean smf73rv4() {
        return Util.ConvertFlag(this.data, this.smf73fg2(), 8);
    }

    public boolean smf73par() {
        return Util.ConvertFlag(this.data, this.smf73fg2(), 4);
    }

    public boolean smf73vac() {
        return Util.ConvertFlag(this.data, this.smf73fg2(), 2);
    }

    public boolean smf73sta() {
        return Util.ConvertFlag(this.data, this.smf73fg2(), 1);
    }

    public int smf73fg3() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf73cnc() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 128);
    }

    public boolean smf73doc() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 64);
    }

    public boolean smf73cvc() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 32);
    }

    public boolean smf73mod() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 16);
    }

    public boolean smf73del() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 8);
    }

    public boolean smf73ins() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 4);
    }

    public boolean smf73vld() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 2);
    }

    public boolean smf73shr() {
        return Util.ConvertFlag(this.data, this.smf73fg3(), 1);
    }

    public int smf73fg4() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf73nvl() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 128);
    }

    public boolean smf73cc() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 64);
    }

    public boolean smf73fxt() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 32);
    }

    public boolean smf73cpm() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 8);
    }

    public boolean smf73cdc() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 4);
    }

    public boolean smf73xcm() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 2);
    }

    public boolean smf73pni() {
        return Util.ConvertFlag(this.data, this.smf73fg4(), 1);
    }

    public long smf73bsy() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public Duration smf73pby() {
        return Util.Binary4x1024MS(this.data, 8);
    }

    public double smf73pbySeconds() {
        return Util.ToSeconds(this.smf73pby());
    }

    public long smf73pbyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public Duration smf73pti() {
        return Util.Binary4x1024MS(this.data, 12);
    }

    public double smf73ptiSeconds() {
        return Util.ToSeconds(this.smf73pti());
    }

    public long smf73ptiRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int smf73cpd() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public String smf73acr() {
        return Util.ConvertEbcdic(this.data, 17, 5);
    }

    public int smf73cmg() {
        return Util.ConvertUnsignedBinary1(this.data, 22);
    }

    public int smf73fg5() {
        return Util.ConvertUnsignedBinary1(this.data, 23);
    }

    public boolean smf73wd1() {
        return Util.ConvertFlag(this.data, this.smf73fg5(), 128);
    }

    public boolean smf73wd2() {
        return Util.ConvertFlag(this.data, this.smf73fg5(), 64);
    }

    public boolean smf73wd3() {
        return Util.ConvertFlag(this.data, this.smf73fg5(), 32);
    }

    public boolean smf73wd4() {
        return Util.ConvertFlag(this.data, this.smf73fg5(), 16);
    }

    public boolean smf73wd5() {
        return Util.ConvertFlag(this.data, this.smf73fg5(), 8);
    }

    public String smf73cm1() {
        if (this.smf73cmg() != 1) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1");
        }
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public Duration smf73tut() {
        if (this.smf73cmg() != 1 || !this.smf73wd1()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1 && smf73wd1() == true");
        }
        return Util.ShortFpHex_128_US(this.data, 24);
    }

    public double smf73tutSeconds() {
        if (this.smf73cmg() != 1 || !this.smf73wd1()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1 && smf73wd1() == true");
        }
        return Util.ToSeconds(this.smf73tut());
    }

    public double smf73tutRawValue() {
        if (this.smf73cmg() != 1 || !this.smf73wd1()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1 && smf73wd1() == true");
        }
        return Util.ConvertShortFPHex(this.data, 24);
    }

    public Duration smf73put() {
        if (this.smf73cmg() != 1 || !this.smf73wd2()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1 && smf73wd2() == true");
        }
        return Util.ShortFpHex_128_US(this.data, 28);
    }

    public double smf73putSeconds() {
        if (this.smf73cmg() != 1 || !this.smf73wd2()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1 && smf73wd2() == true");
        }
        return Util.ToSeconds(this.smf73put());
    }

    public double smf73putRawValue() {
        if (this.smf73cmg() != 1 || !this.smf73wd2()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 1 && smf73wd2() == true");
        }
        return Util.ConvertShortFPHex(this.data, 28);
    }

    public double smf73mbc() {
        if (this.smf73cmg() != 2 || !this.smf73wd1()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2 && smf73wd1() == true");
        }
        return Util.ConvertShortFPHex(this.data, 24);
    }

    public double smf73mcu() {
        if (this.smf73cmg() != 2 || !this.smf73wd2()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2 && smf73wd2() == true");
        }
        return Util.ConvertShortFPHex(this.data, 28);
    }

    public double smf73mwu() {
        if (this.smf73cmg() != 2 || !this.smf73wd3()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2 && smf73wd3() == true");
        }
        return Util.ConvertShortFPHex(this.data, 32);
    }

    public double smf73mru() {
        if (this.smf73cmg() != 2 || !this.smf73wd4()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2 && smf73wd4() == true");
        }
        return Util.ConvertShortFPHex(this.data, 36);
    }

    public double smf73us() {
        if (this.smf73cmg() != 2 || !this.smf73wd5()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2 && smf73wd5() == true");
        }
        return Util.ConvertShortFPHex(this.data, 40);
    }

    public double smf73tbc() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 44);
    }

    public double smf73tuc() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 48);
    }

    public double smf73puc() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 52);
    }

    public double smf73twu() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 56);
    }

    public double smf73pwu() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 60);
    }

    public double smf73tru() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 64);
    }

    public double smf73pru() {
        if (this.smf73cmg() != 2) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 2");
        }
        return Util.ConvertShortFPHex(this.data, 68);
    }

    public double smf73pdu() {
        if (this.smf73cmg() != 3 || !this.smf73wd1()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3 && smf73wd1() == true");
        }
        return Util.ConvertShortFPHex(this.data, 24);
    }

    public double smf73tdu() {
        if (this.smf73cmg() != 3 || !this.smf73wd2()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3 && smf73wd2() == true");
        }
        return Util.ConvertShortFPHex(this.data, 28);
    }

    public double smf73pum() {
        if (this.smf73cmg() != 3 || !this.smf73wd3()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3 && smf73wd3() == true");
        }
        return Util.ConvertShortFPHex(this.data, 32);
    }

    public double smf73tum() {
        if (this.smf73cmg() != 3 || !this.smf73wd4()) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3 && smf73wd4() == true");
        }
        return Util.ConvertShortFPHex(this.data, 36);
    }

    public double smf73pms() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 44);
    }

    public double smf73tms() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 48);
    }

    public double smf73pus() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 52);
    }

    public double smf73pub() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 56);
    }

    public double smf73tub() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 60);
    }

    public double smf73pds() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 64);
    }

    public double smf73tds() {
        if (this.smf73cmg() != 3) {
            throw new NotAvailableException("This method is only supported when smf73cmg() == 3");
        }
        return Util.ConvertShortFPHex(this.data, 68);
    }

    public int smf73cpp() {
        return Util.ConvertUnsignedBinary1(this.data, 72);
    }

    public int smf73gen() {
        return Util.ConvertUnsignedBinary1(this.data, 73);
    }

    public int smf73eix() {
        if (!this.smf73xcm()) {
            throw new NotAvailableException("This method is only supported when smf73xcm() == true");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf73spd() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int smf73msc() {
        return Util.ConvertUnsignedBinary1(this.data, 78, 15);
    }

    public String smf73nt1() {
        return Util.ConvertEbcdic(this.data, 80, 16);
    }

    public String smf73nt2() {
        return Util.ConvertEbcdic(this.data, 96, 16);
    }

    public static ChannelPathDataSection create(byte[] Data2, int offset, int length) {
        return new ChannelPathDataSection(Data2, offset, length);
    }

    static enum Field {
        smf73pid(0, 1),
        smf73fg2(1, 1),
        smf73fg3(2, 1),
        smf73fg4(3, 1),
        smf73bsy(4, 4),
        smf73pby(8, 4),
        smf73pti(12, 4),
        smf73cpd(16, 1),
        smf73acr(17, 5),
        smf73cmg(22, 1),
        smf73fg5(23, 1),
        smf73cm1(24, 8),
        smf73tut(24, 4),
        smf73put(28, 4),
        smf73mbc(24, 4),
        smf73mcu(28, 4),
        smf73mwu(32, 4),
        smf73mru(36, 4),
        smf73us(40, 4),
        smf73tbc(44, 4),
        smf73tuc(48, 4),
        smf73puc(52, 4),
        smf73twu(56, 4),
        smf73pwu(60, 4),
        smf73tru(64, 4),
        smf73pru(68, 4),
        smf73pdu(24, 4),
        smf73tdu(28, 4),
        smf73pum(32, 4),
        smf73tum(36, 4),
        smf73pms(44, 4),
        smf73tms(48, 4),
        smf73pus(52, 4),
        smf73pub(56, 4),
        smf73tub(60, 4),
        smf73pds(64, 4),
        smf73tds(68, 4),
        smf73cpp(72, 1),
        smf73gen(73, 1),
        smf73eix(74, 2),
        smf73spd(76, 2),
        smf73msc(78, 1),
        smf73nt1(80, 16),
        smf73nt2(96, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

