/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype3;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class KernelControlDataSection
extends SmfData {
    public static final int R743TER = Integer.MIN_VALUE;
    public static final int R743CHPR = 0x40000000;
    public static final int R743CHUS = 0x20000000;
    public static final int R743CHPU = 0x10000000;
    public static final int R743CHMS = 0x8000000;
    public static final int R743CHSE = 0x4000000;
    public static final int R743CHSH = 0x2000000;
    public static final int R743CHSP = 0x1000000;
    public static final int R743CHMA = 0x800000;
    public static final int R743CHPA = 0x400000;
    public static final int R743CHLR = 0x200000;
    public static final int R743CQSG = 0x100000;

    private KernelControlDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r743cycu() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public Duration r743cyct() {
        return Util.Binary4MS(this.data, 4);
    }

    public double r743cyctSeconds() {
        return Util.ToSeconds(this.r743cyct());
    }

    public long r743cyctRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long r743flg() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public boolean r743ter() {
        return Util.ConvertFlag(this.data, this.r743flg(), Integer.MIN_VALUE);
    }

    public boolean r743chpr() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x40000000L);
    }

    public boolean r743chus() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x20000000L);
    }

    public boolean r743chpu() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x10000000L);
    }

    public boolean r743chms() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x8000000L);
    }

    public boolean r743chse() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x4000000L);
    }

    public boolean r743chsh() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x2000000L);
    }

    public boolean r743chsp() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x1000000L);
    }

    public boolean r743chma() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x800000L);
    }

    public boolean r743chpa() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x400000L);
    }

    public boolean r743chlr() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x200000L);
    }

    public boolean r743cqsg() {
        return Util.ConvertFlag(this.data, this.r743flg(), 0x100000L);
    }

    public double r743sysc() {
        return Util.ConvertShortFPHex(this.data, 12);
    }

    public long r743scmn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long r743scmx() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public Duration r743cpu() {
        return Util.ShortFpHex_10_MS(this.data, 24);
    }

    public double r743cpuSeconds() {
        return Util.ToSeconds(this.r743cpu());
    }

    public double r743cpuRawValue() {
        return Util.ConvertShortFPHex(this.data, 24);
    }

    public Duration r743ctmn() {
        return Util.Binary4_10MS(this.data, 28);
    }

    public double r743ctmnSeconds() {
        return Util.ToSeconds(this.r743ctmn());
    }

    public long r743ctmnRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration r743ctmx() {
        return Util.Binary4_10MS(this.data, 32);
    }

    public double r743ctmxSeconds() {
        return Util.ToSeconds(this.r743ctmx());
    }

    public long r743ctmxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public double r743opr() {
        return Util.ConvertShortFPHex(this.data, 36);
    }

    public long r743opmn() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long r743opmx() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public double r743ous() {
        return Util.ConvertShortFPHex(this.data, 48);
    }

    public long r743oumn() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long r743oumx() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public double r743opru() {
        return Util.ConvertShortFPHex(this.data, 60);
    }

    public long r743ormn() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long r743ormx() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public int r743maxp() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int r743maxu() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int r743mxpu() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public double r743curp() {
        return Util.ConvertShortFPHex(this.data, 80);
    }

    public int r743cpmn() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public int r743cpmx() {
        return Util.ConvertUnsignedBinary2(this.data, 86);
    }

    public double r743curu() {
        return Util.ConvertShortFPHex(this.data, 88);
    }

    public int r743cumn() {
        return Util.ConvertUnsignedBinary2(this.data, 92);
    }

    public int r743cumx() {
        return Util.ConvertUnsignedBinary2(this.data, 94);
    }

    public long r743mmsg() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long r743msem() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long r743mshm() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long r743mspg() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public double r743cmsg() {
        return Util.ConvertShortFPHex(this.data, 112);
    }

    public long r743cmmn() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long r743cmmx() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public double r743csem() {
        return Util.ConvertShortFPHex(this.data, 124);
    }

    public long r743csmn() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long r743csmx() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public double r743cshm() {
        return Util.ConvertShortFPHex(this.data, 136);
    }

    public long r743chmn() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long r743chmx() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public double r743cspg() {
        return Util.ConvertShortFPHex(this.data, 148);
    }

    public long r743cgmn() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long r743cgmx() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public double r743omsg() {
        return Util.ConvertShortFPHex(this.data, 160);
    }

    public long r743ommn() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long r743ommx() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public double r743osem() {
        return Util.ConvertShortFPHex(this.data, 172);
    }

    public long r743osmn() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long r743osmx() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public double r743oshm() {
        return Util.ConvertShortFPHex(this.data, 184);
    }

    public long r743ohmn() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long r743ohmx() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public double r743ospg() {
        return Util.ConvertShortFPHex(this.data, 196);
    }

    public long r743ogmn() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long r743ogmx() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long r743mmap() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public double r743cmap() {
        return Util.ConvertShortFPHex(this.data, 212);
    }

    public long r743camn() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public long r743camx() {
        return Util.ConvertUnsignedBinary4(this.data, 220);
    }

    public double r743omap() {
        return Util.ConvertShortFPHex(this.data, 224);
    }

    public long r743oamn() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public long r743oamx() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public long r743mpag() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public double r743cpag() {
        return Util.ConvertShortFPHex(this.data, 240);
    }

    public long r743cxmn() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long r743cxmx() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public double r743opag() {
        return Util.ConvertShortFPHex(this.data, 252);
    }

    public long r743oxmn() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long r743oxmx() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long r743mslr() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public double r743cslr() {
        return Util.ConvertShortFPHex(this.data, 268);
    }

    public long r743clmn() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long r743clmx() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public double r743oslr() {
        return Util.ConvertShortFPHex(this.data, 280);
    }

    public long r743olmn() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public long r743olmx() {
        return Util.ConvertUnsignedBinary4(this.data, 288);
    }

    public long r743mqds() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public double r743oqds() {
        return Util.ConvertShortFPHex(this.data, 296);
    }

    public long r743oqmn() {
        return Util.ConvertUnsignedBinary4(this.data, 300);
    }

    public long r743oqmx() {
        return Util.ConvertUnsignedBinary4(this.data, 304);
    }

    public static KernelControlDataSection create(byte[] Data2, int offset, int length) {
        return new KernelControlDataSection(Data2, offset, length);
    }

    static enum Field {
        r743cycu(0, 4),
        r743cyct(4, 4),
        r743flg(8, 4),
        r743sysc(12, 4),
        r743scmn(16, 4),
        r743scmx(20, 4),
        r743cpu(24, 4),
        r743ctmn(28, 4),
        r743ctmx(32, 4),
        r743opr(36, 4),
        r743opmn(40, 4),
        r743opmx(44, 4),
        r743ous(48, 4),
        r743oumn(52, 4),
        r743oumx(56, 4),
        r743opru(60, 4),
        r743ormn(64, 4),
        r743ormx(68, 4),
        r743maxp(72, 2),
        r743maxu(74, 2),
        r743mxpu(76, 2),
        r743curp(80, 4),
        r743cpmn(84, 2),
        r743cpmx(86, 2),
        r743curu(88, 4),
        r743cumn(92, 2),
        r743cumx(94, 2),
        r743mmsg(96, 4),
        r743msem(100, 4),
        r743mshm(104, 4),
        r743mspg(108, 4),
        r743cmsg(112, 4),
        r743cmmn(116, 4),
        r743cmmx(120, 4),
        r743csem(124, 4),
        r743csmn(128, 4),
        r743csmx(132, 4),
        r743cshm(136, 4),
        r743chmn(140, 4),
        r743chmx(144, 4),
        r743cspg(148, 4),
        r743cgmn(152, 4),
        r743cgmx(156, 4),
        r743omsg(160, 4),
        r743ommn(164, 4),
        r743ommx(168, 4),
        r743osem(172, 4),
        r743osmn(176, 4),
        r743osmx(180, 4),
        r743oshm(184, 4),
        r743ohmn(188, 4),
        r743ohmx(192, 4),
        r743ospg(196, 4),
        r743ogmn(200, 4),
        r743ogmx(204, 4),
        r743mmap(208, 4),
        r743cmap(212, 4),
        r743camn(216, 4),
        r743camx(220, 4),
        r743omap(224, 4),
        r743oamn(228, 4),
        r743oamx(232, 4),
        r743mpag(236, 4),
        r743cpag(240, 4),
        r743cxmn(244, 4),
        r743cxmx(248, 4),
        r743opag(252, 4),
        r743oxmn(256, 4),
        r743oxmx(260, 4),
        r743mslr(264, 4),
        r743cslr(268, 4),
        r743clmn(272, 4),
        r743clmx(276, 4),
        r743oslr(280, 4),
        r743olmn(284, 4),
        r743olmx(288, 4),
        r743mqds(292, 4),
        r743oqds(296, 4),
        r743oqmn(300, 4),
        r743oqmx(304, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

