/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype4;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class CfRequestDataSection
extends SmfData {
    private final long r744flvl;
    public static final int R744STY1 = 1;
    public static final int R744STY2 = 2;
    public static final int R744STY3 = 3;
    public static final int R744STY4 = 4;
    public static final int R744SCEI = 128;
    public static final int R744SADI = 64;
    public static final int R744SCAD = 32;
    public static final int R744SDAS = 16;
    public static final int R744SPRI = 8;
    public static final int R744SSEC = 4;
    public static final int R744SENC = 2;
    public static final int R744SXAP = 128;
    public static final int R744SXAS = 64;
    public static final int R744SXCM = 32;
    public static final int R744SXMO = 16;

    private CfRequestDataSection(byte[] Data2, int offset, int length, long r744flvl) {
        super(Data2, offset, length);
        this.r744flvl = r744flvl;
    }

    public String r744snam() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public long r744sver() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger r744sverAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public int r744styp() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public boolean r744sty1() {
        return Util.ConvertEquateValue(this.data, this.r744styp(), 1);
    }

    public boolean r744sty2() {
        return Util.ConvertEquateValue(this.data, this.r744styp(), 2);
    }

    public boolean r744sty3() {
        return Util.ConvertEquateValue(this.data, this.r744styp(), 3);
    }

    public boolean r744sty4() {
        return Util.ConvertEquateValue(this.data, this.r744styp(), 4);
    }

    public int r744sflg() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public boolean r744scei() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 128);
    }

    public boolean r744sadi() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 64);
    }

    public boolean r744scad() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 32);
    }

    public boolean r744sdas() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 16);
    }

    public boolean r744spri() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 8);
    }

    public boolean r744ssec() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 4);
    }

    public boolean r744senc() {
        return Util.ConvertFlag(this.data, this.r744sflg(), 2);
    }

    public int r744slec() {
        return Util.ConvertUnsignedBinary1(this.data, 27);
    }

    public long r744slel() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long r744slem() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long r744sltl() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long r744sltm() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public double r744ssta() {
        return Util.ConvertLongFPHex(this.data, 44);
    }

    public double r744strc() {
        return Util.ConvertLongFPHex(this.data, 52);
    }

    public double r744stac() {
        return Util.ConvertLongFPHex(this.data, 60);
    }

    public double r744sarc() {
        return Util.ConvertLongFPHex(this.data, 68);
    }

    public Duration r744satm() {
        return Util.Binary8USSeconds(this.data, 76);
    }

    public double r744satmSeconds() {
        return Util.ToSeconds(this.r744satm());
    }

    public BigInteger r744satmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public double r744sasqSecondsSq() {
        return Util.Binary8USSquared(this.data, 84);
    }

    public BigInteger r744sasqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 84);
    }

    public double r744ssrc() {
        return Util.ConvertLongFPHex(this.data, 92);
    }

    public Duration r744sstm() {
        return Util.Binary8USSeconds(this.data, 100);
    }

    public double r744sstmSeconds() {
        return Util.ToSeconds(this.r744sstm());
    }

    public BigInteger r744sstmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 100);
    }

    public double r744sssqSecondsSq() {
        return Util.Binary8USSquared(this.data, 108);
    }

    public BigInteger r744sssqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 108);
    }

    public double r744sqrc() {
        return Util.ConvertLongFPHex(this.data, 116);
    }

    public Duration r744sqtm() {
        return Util.Binary8USSeconds(this.data, 124);
    }

    public double r744sqtmSeconds() {
        return Util.ToSeconds(this.r744sqtm());
    }

    public BigInteger r744sqtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 124);
    }

    public double r744sqsqSecondsSq() {
        return Util.Binary8USSquared(this.data, 132);
    }

    public BigInteger r744sqsqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 132);
    }

    public double r744sdrc() {
        return Util.ConvertLongFPHex(this.data, 140);
    }

    public Duration r744sdtm() {
        return Util.Binary8USSeconds(this.data, 148);
    }

    public double r744sdtmSeconds() {
        return Util.ToSeconds(this.r744sdtm());
    }

    public BigInteger r744sdtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 148);
    }

    public double r744sdsqSecondsSq() {
        return Util.Binary8USSquared(this.data, 156);
    }

    public BigInteger r744sdsqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 156);
    }

    public double r744sdmp() {
        return Util.ConvertLongFPHex(this.data, 164);
    }

    public double r744shto() {
        return Util.ConvertLongFPHex(this.data, 172);
    }

    public long r744shmn() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long r744shmx() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public double r744slto() {
        return Util.ConvertLongFPHex(this.data, 188);
    }

    public long r744slmn() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long r744slmx() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public double r744sdto() {
        return Util.ConvertLongFPHex(this.data, 204);
    }

    public long r744sdmn() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long r744sdmx() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public double r744scn() {
        return Util.ConvertLongFPHex(this.data, 220);
    }

    public double r744sfcn() {
        return Util.ConvertLongFPHex(this.data, 228);
    }

    public long r744ssiz() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public long r744smas() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long r744smis() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long r744sdec() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public long r744sdel() {
        return Util.ConvertUnsignedBinary4(this.data, 252);
    }

    public long r744snlh() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long r744smae() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long r744scue() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public int r744cdsi() {
        return Util.ConvertUnsignedBinary2(this.data, 268);
    }

    public int r744cdne() {
        return Util.ConvertUnsignedBinary2(this.data, 270);
    }

    public double r744spln() {
        return Util.ConvertLongFPHex(this.data, 272);
    }

    public double r744spes() {
        return Util.ConvertLongFPHex(this.data, 280);
    }

    public double r744sptc() {
        return Util.ConvertLongFPHex(this.data, 288);
    }

    public Duration r744spst() {
        return Util.Binary8USSeconds(this.data, 296);
    }

    public double r744spstSeconds() {
        return Util.ToSeconds(this.r744spst());
    }

    public BigInteger r744spstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 296);
    }

    public double r744spssSecondsSq() {
        return Util.Binary8USSquared(this.data, 304);
    }

    public BigInteger r744spssRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 304);
    }

    public double r744srtc() {
        return Util.ConvertLongFPHex(this.data, 312);
    }

    public Duration r744srst() {
        return Util.Binary8USSeconds(this.data, 320);
    }

    public double r744srstSeconds() {
        return Util.ToSeconds(this.r744srst());
    }

    public BigInteger r744srstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 320);
    }

    public double r744srssSecondsSq() {
        return Util.Binary8USSquared(this.data, 328);
    }

    public BigInteger r744srssRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 328);
    }

    public double r744sctc() {
        return Util.ConvertLongFPHex(this.data, 336);
    }

    public Duration r744scst() {
        return Util.Binary8USSeconds(this.data, 344);
    }

    public double r744scstSeconds() {
        return Util.ToSeconds(this.r744scst());
    }

    public BigInteger r744scstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 344);
    }

    public double r744scssSecondsSq() {
        return Util.Binary8USSquared(this.data, 352);
    }

    public BigInteger r744scssRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public ZonedDateTime r744slsv() {
        return Util.Binary8xStckTime(this.data, 360);
    }

    public BigInteger r744slsvRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public Duration r744setm() {
        if (this.r744flvl <= 14L) {
            throw new NotAvailableException("This method is only supported when r744flvl() > 14");
        }
        return Util.LongFpHex_US(this.data, 368);
    }

    public double r744setmSeconds() {
        return Util.ToSeconds(this.r744setm());
    }

    public double r744setmRawValue() {
        if (this.r744flvl <= 14L) {
            throw new NotAvailableException("This method is only supported when r744flvl() > 14");
        }
        return Util.ConvertLongFPHex(this.data, 368);
    }

    public int r744sisc() {
        return Util.ConvertUnsignedBinary2(this.data, 376);
    }

    public int r744snsc() {
        return Util.ConvertUnsignedBinary2(this.data, 378);
    }

    public long r744ssac() {
        return Util.ConvertUnsignedBinary4(this.data, 380);
    }

    public long r744sosa() {
        return Util.ConvertUnsignedBinary4(this.data, 384);
    }

    public int r744siad() {
        return Util.ConvertUnsignedBinary2(this.data, 388);
    }

    public int r744sadn() {
        return Util.ConvertUnsignedBinary2(this.data, 390);
    }

    public long r744sixc() {
        return Util.ConvertUnsignedBinary4(this.data, 392);
    }

    public long r744sxsc() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public Duration r744sxst() {
        return Util.Binary8USSeconds(this.data, 400);
    }

    public double r744sxstSeconds() {
        return Util.ToSeconds(this.r744sxst());
    }

    public BigInteger r744sxstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 400);
    }

    public double r744sxsqSecondsSq() {
        return Util.Binary8USSquared(this.data, 408);
    }

    public BigInteger r744sxsqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 408);
    }

    public long r744sado() {
        return Util.ConvertUnsignedBinary4(this.data, 416);
    }

    public long r744sadr() {
        return Util.ConvertUnsignedBinary4(this.data, 420);
    }

    public int r744sqch() {
        return Util.ConvertUnsignedBinary1(this.data, 424);
    }

    public int r744sxfl() {
        return Util.ConvertUnsignedBinary1(this.data, 425);
    }

    public boolean r744sxap() {
        return Util.ConvertFlag(this.data, this.r744sxfl(), 128);
    }

    public boolean r744sxas() {
        return Util.ConvertFlag(this.data, this.r744sxfl(), 64);
    }

    public boolean r744sxcm() {
        return Util.ConvertFlag(this.data, this.r744sxfl(), 32);
    }

    public boolean r744sxmo() {
        return Util.ConvertFlag(this.data, this.r744sxfl(), 16);
    }

    public long r744swdr() {
        return Util.ConvertUnsignedBinary4(this.data, 428);
    }

    public long r744swac() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    public long r744srdr() {
        return Util.ConvertUnsignedBinary4(this.data, 436);
    }

    public long r744srac() {
        return Util.ConvertUnsignedBinary4(this.data, 440);
    }

    public long r744swec() {
        return Util.ConvertUnsignedBinary4(this.data, 444);
    }

    public long r744srec() {
        return Util.ConvertUnsignedBinary4(this.data, 448);
    }

    public long r744swed() {
        return Util.ConvertUnsignedBinary8(this.data, 456);
    }

    public BigInteger r744swedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 456);
    }

    public long r744swes() {
        return Util.ConvertUnsignedBinary8(this.data, 464);
    }

    public BigInteger r744swesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 464);
    }

    public long r744sred() {
        return Util.ConvertUnsignedBinary8(this.data, 472);
    }

    public BigInteger r744sredAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 472);
    }

    public long r744sres() {
        return Util.ConvertUnsignedBinary8(this.data, 480);
    }

    public BigInteger r744sresAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 480);
    }

    public long r744smrc() {
        return Util.ConvertUnsignedBinary8(this.data, 488);
    }

    public BigInteger r744smrcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 488);
    }

    public Duration r744smtm() {
        return Util.Binary8USSeconds(this.data, 496);
    }

    public double r744smtmSeconds() {
        return Util.ToSeconds(this.r744smtm());
    }

    public BigInteger r744smtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 496);
    }

    public long r744smsq() {
        return Util.ConvertUnsignedBinary8(this.data, 504);
    }

    public BigInteger r744smsqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 504);
    }

    public long r744smto() {
        return Util.ConvertUnsignedBinary8(this.data, 512);
    }

    public BigInteger r744smtoAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 512);
    }

    public long r744smht() {
        return Util.ConvertUnsignedBinary8(this.data, 520);
    }

    public BigInteger r744smhtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 520);
    }

    public long r744smmn() {
        return Util.ConvertUnsignedBinary4(this.data, 528);
    }

    public long r744smmx() {
        return Util.ConvertUnsignedBinary4(this.data, 532);
    }

    public long r744smhn() {
        return Util.ConvertUnsignedBinary4(this.data, 536);
    }

    public long r744smhx() {
        return Util.ConvertUnsignedBinary4(this.data, 540);
    }

    public static CfRequestDataSection create(byte[] Data2, int offset, int length, long r744flvl) {
        return new CfRequestDataSection(Data2, offset, length, r744flvl);
    }

    static enum Field {
        r744snam(0, 16),
        r744sver(16, 8),
        r744styp(24, 1),
        r744sflg(25, 1),
        r744slec(27, 1),
        r744slel(28, 4),
        r744slem(32, 4),
        r744sltl(36, 4),
        r744sltm(40, 4),
        r744ssta(44, 8),
        r744strc(52, 8),
        r744stac(60, 8),
        r744sarc(68, 8),
        r744satm(76, 8),
        r744sasq(84, 8),
        r744ssrc(92, 8),
        r744sstm(100, 8),
        r744sssq(108, 8),
        r744sqrc(116, 8),
        r744sqtm(124, 8),
        r744sqsq(132, 8),
        r744sdrc(140, 8),
        r744sdtm(148, 8),
        r744sdsq(156, 8),
        r744sdmp(164, 8),
        r744shto(172, 8),
        r744shmn(180, 4),
        r744shmx(184, 4),
        r744slto(188, 8),
        r744slmn(196, 4),
        r744slmx(200, 4),
        r744sdto(204, 8),
        r744sdmn(212, 4),
        r744sdmx(216, 4),
        r744scn(220, 8),
        r744sfcn(228, 8),
        r744ssiz(236, 4),
        r744smas(240, 4),
        r744smis(244, 4),
        r744sdec(248, 4),
        r744sdel(252, 4),
        r744snlh(256, 4),
        r744smae(260, 4),
        r744scue(264, 4),
        r744cdsi(268, 2),
        r744cdne(270, 2),
        r744spln(272, 8),
        r744spes(280, 8),
        r744sptc(288, 8),
        r744spst(296, 8),
        r744spss(304, 8),
        r744srtc(312, 8),
        r744srst(320, 8),
        r744srss(328, 8),
        r744sctc(336, 8),
        r744scst(344, 8),
        r744scss(352, 8),
        r744slsv(360, 8),
        r744setm(368, 8),
        r744sisc(376, 2),
        r744snsc(378, 2),
        r744ssac(380, 4),
        r744sosa(384, 4),
        r744siad(388, 2),
        r744sadn(390, 2),
        r744sixc(392, 4),
        r744sxsc(396, 4),
        r744sxst(400, 8),
        r744sxsq(408, 8),
        r744sado(416, 4),
        r744sadr(420, 4),
        r744sqch(424, 1),
        r744sxfl(425, 1),
        r744swdr(428, 4),
        r744swac(432, 4),
        r744srdr(436, 4),
        r744srac(440, 4),
        r744swec(444, 4),
        r744srec(448, 4),
        r744swed(456, 8),
        r744swes(464, 8),
        r744sred(472, 8),
        r744sres(480, 8),
        r744smrc(488, 8),
        r744smtm(496, 8),
        r744smsq(504, 8),
        r744smto(512, 8),
        r744smht(520, 8),
        r744smmn(528, 4),
        r744smmx(532, 4),
        r744smhn(536, 4),
        r744smhx(540, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

