/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype5;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class CacheDeviceDataSection
extends SmfData {
    public static final int R745DEV4 = 128;
    public static final int R745DNAV = 128;
    public static final int R745DPDF = 112;
    public static final int R745DFRM = 15;
    public static final int R745DSDV = 192;
    public static final int R745DSFW = 48;
    public static final int R745DSPD = 8;
    public static final int R745DSSD = 4;
    public static final int R745DSDP = 3;
    public static final int R745DSDF = 128;
    public static final int R745DSPN = 64;
    public static final int R745DSOD = 63;
    public static final int R745DCOL = 192;
    public static final int R745DEFN = 32;
    public static final int R745DBDP = 16;
    public static final int R745DVST = 12;
    public static final int R745DPDT = 3;

    private CacheDeviceDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String r745dvol() {
        return Util.ConvertEbcdic(this.data, 0, 6);
    }

    public int r745dfl4() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public boolean r745dev4() {
        return Util.ConvertFlag(this.data, this.r745dfl4(), 128);
    }

    public int r745dscs() {
        return Util.ConvertUnsignedBits(this.data, 6, 2, 2);
    }

    public String r745dcid() {
        return Util.ConvertEbcdic(this.data, 7, 1);
    }

    public String r745dccu() {
        return Util.ConvertEbcdic(this.data, 7, 1);
    }

    public int r745dunt() {
        return Util.ConvertUnsignedBinary3(this.data, 8);
    }

    public int r745devn() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public int r745dflg() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public boolean r745dnav() {
        return Util.ConvertFlag(this.data, this.r745dflg(), 128);
    }

    public int r745dvid() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public int r745dvs1() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public boolean r745dspd() {
        return Util.ConvertFlag(this.data, this.r745dvs1(), 8);
    }

    public boolean r745dssd() {
        return Util.ConvertFlag(this.data, this.r745dvs1(), 4);
    }

    public int r745dvs2() {
        return Util.ConvertUnsignedBinary1(this.data, 19);
    }

    public boolean r745dsdf() {
        return Util.ConvertFlag(this.data, this.r745dvs2(), 128);
    }

    public boolean r745dspn() {
        return Util.ConvertFlag(this.data, this.r745dvs2(), 64);
    }

    public double r745drcr() {
        return Util.ConvertShortFPHex(this.data, 20);
    }

    public double r745dcrh() {
        return Util.ConvertShortFPHex(this.data, 24);
    }

    public double r745dwrc() {
        return Util.ConvertShortFPHex(this.data, 28);
    }

    public double r745dwch() {
        return Util.ConvertShortFPHex(this.data, 32);
    }

    public double r745drsr() {
        return Util.ConvertShortFPHex(this.data, 36);
    }

    public double r745drsh() {
        return Util.ConvertShortFPHex(this.data, 40);
    }

    public double r745dwsr() {
        return Util.ConvertShortFPHex(this.data, 44);
    }

    public double r745dwsh() {
        return Util.ConvertShortFPHex(this.data, 48);
    }

    public double r745drnr() {
        return Util.ConvertShortFPHex(this.data, 52);
    }

    public double r745dnrh() {
        return Util.ConvertShortFPHex(this.data, 56);
    }

    public double r745dwnr() {
        return Util.ConvertShortFPHex(this.data, 60);
    }

    public double r745dwnh() {
        return Util.ConvertShortFPHex(this.data, 64);
    }

    public double r745dicl() {
        return Util.ConvertShortFPHex(this.data, 68);
    }

    public double r745dbcr() {
        return Util.ConvertShortFPHex(this.data, 72);
    }

    public double r745dtc() {
        return Util.ConvertShortFPHex(this.data, 76);
    }

    public double r745dntd() {
        return Util.ConvertShortFPHex(this.data, 80);
    }

    public double r745dctd() {
        return Util.ConvertShortFPHex(this.data, 84);
    }

    public double r745dfwb() {
        return Util.ConvertShortFPHex(this.data, 88);
    }

    public double r745dfwc() {
        return Util.ConvertShortFPHex(this.data, 92);
    }

    public double r745dfws() {
        return Util.ConvertShortFPHex(this.data, 96);
    }

    public double r745dcrm() {
        return Util.ConvertShortFPHex(this.data, 100);
    }

    public int r745dsg2() {
        return Util.ConvertUnsignedBinary1(this.data, 104);
    }

    public boolean r745defn() {
        return Util.ConvertFlag(this.data, this.r745dsg2(), 32);
    }

    public boolean r745dbdp() {
        return Util.ConvertFlag(this.data, this.r745dsg2(), 16);
    }

    public int r745incr() {
        return Util.ConvertUnsignedBinary1(this.data, 105);
    }

    public int r745dsid() {
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public double r745dcwp() {
        return Util.ConvertShortFPHex(this.data, 108);
    }

    public double r745dkdw() {
        return Util.ConvertShortFPHex(this.data, 112);
    }

    public double r745dkdh() {
        return Util.ConvertShortFPHex(this.data, 116);
    }

    public double r745dfwr() {
        return Util.ConvertShortFPHex(this.data, 120);
    }

    public double r745bytr() {
        return Util.ConvertShortFPHex(this.data, 124);
    }

    public double r745bytw() {
        return Util.ConvertShortFPHex(this.data, 128);
    }

    public Duration r745rtir() {
        return Util.ShortFpHex_16_MS(this.data, 132);
    }

    public double r745rtirSeconds() {
        return Util.ToSeconds(this.r745rtir());
    }

    public double r745rtirRawValue() {
        return Util.ConvertShortFPHex(this.data, 132);
    }

    public Duration r745rtiw() {
        return Util.ShortFpHex_16_MS(this.data, 136);
    }

    public double r745rtiwSeconds() {
        return Util.ToSeconds(this.r745rtiw());
    }

    public double r745rtiwRawValue() {
        return Util.ConvertShortFPHex(this.data, 136);
    }

    public static CacheDeviceDataSection create(byte[] Data2, int offset, int length) {
        return new CacheDeviceDataSection(Data2, offset, length);
    }

    static enum Field {
        r745dvol(0, 6),
        r745dfl4(6, 1),
        r745dscs(6, 0),
        r745dcid(7, 1),
        r745dccu(7, 1),
        r745dunt(8, 3),
        r745devn(12, 2),
        r745dflg(16, 1),
        r745dvid(17, 1),
        r745dvs1(18, 1),
        r745dvs2(19, 1),
        r745drcr(20, 4),
        r745dcrh(24, 4),
        r745dwrc(28, 4),
        r745dwch(32, 4),
        r745drsr(36, 4),
        r745drsh(40, 4),
        r745dwsr(44, 4),
        r745dwsh(48, 4),
        r745drnr(52, 4),
        r745dnrh(56, 4),
        r745dwnr(60, 4),
        r745dwnh(64, 4),
        r745dicl(68, 4),
        r745dbcr(72, 4),
        r745dtc(76, 4),
        r745dntd(80, 4),
        r745dctd(84, 4),
        r745dfwb(88, 4),
        r745dfwc(92, 4),
        r745dfws(96, 4),
        r745dcrm(100, 4),
        r745dsg2(104, 1),
        r745incr(105, 1),
        r745dsid(106, 2),
        r745dcwp(108, 4),
        r745dkdw(112, 4),
        r745dkdh(116, 4),
        r745dfwr(120, 4),
        r745bytr(124, 4),
        r745bytw(128, 4),
        r745rtir(132, 4),
        r745rtiw(136, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

