/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype6;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class HfsGlobalDataSection
extends SmfData {
    public static final int R746GONR = 128;
    public static final int R746GNBL = 64;
    public static final int R746GNGD = 32;
    public static final int R746GPGD = 16;

    private HfsGlobalDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r746gmxv() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long r746gusv() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long r746gmnf() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long r746gusf() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public double r746gmc() {
        return Util.ConvertLongFPHex(this.data, 16);
    }

    public double r746gmnc() {
        return Util.ConvertLongFPHex(this.data, 24);
    }

    public double r746g1c() {
        return Util.ConvertLongFPHex(this.data, 32);
    }

    public double r746g1nc() {
        return Util.ConvertLongFPHex(this.data, 40);
    }

    public long r746glrc() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long r746glrs() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long r746gsrc() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long r746gsrs() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public int r746gsfl() {
        return Util.ConvertUnsignedBinary1(this.data, 64);
    }

    public boolean r746gonr() {
        return Util.ConvertFlag(this.data, this.r746gsfl(), 128);
    }

    public boolean r746gnbl() {
        return Util.ConvertFlag(this.data, this.r746gsfl(), 64);
    }

    public boolean r746gngd() {
        return Util.ConvertFlag(this.data, this.r746gsfl(), 32);
    }

    public boolean r746gpgd() {
        return Util.ConvertFlag(this.data, this.r746gsfl(), 16);
    }

    public static HfsGlobalDataSection create(byte[] Data2, int offset, int length) {
        return new HfsGlobalDataSection(Data2, offset, length);
    }

    static enum Field {
        r746gmxv(0, 4),
        r746gusv(4, 4),
        r746gmnf(8, 4),
        r746gusf(12, 4),
        r746gmc(16, 8),
        r746gmnc(24, 8),
        r746g1c(32, 8),
        r746g1nc(40, 8),
        r746glrc(48, 4),
        r746glrs(52, 4),
        r746gsrc(56, 4),
        r746gsrs(60, 4),
        r746gsfl(64, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

