/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype9;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class PcieDmaDataSection
extends SmfData {
    private PcieDmaDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r749dmar() {
        if (this.r749dfmt() != 0) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 0");
        }
        return Util.ConvertUnsignedBinary8(this.data, 0);
    }

    public BigInteger r749dmarAsBigInteger() {
        if (this.r749dfmt() != 0) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 0");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public long r749dwup() {
        if (this.r749dfmt() != 2) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 2");
        }
        return Util.ConvertUnsignedBinary8(this.data, 0);
    }

    public BigInteger r749dwupAsBigInteger() {
        if (this.r749dfmt() != 2) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 2");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public long r749srbf() {
        if (this.r749dfmt() != 4) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 4");
        }
        return Util.ConvertUnsignedBinary8(this.data, 0);
    }

    public BigInteger r749srbfAsBigInteger() {
        if (this.r749dfmt() != 4) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 4");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public long r749dbyr() {
        return Util.ConvertUnsignedBinary8(this.data, 0);
    }

    public BigInteger r749dbyrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public long r749dmaw() {
        if (this.r749dfmt() != 0) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 0");
        }
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger r749dmawAsBigInteger() {
        if (this.r749dfmt() != 0) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 0");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long r749dwum() {
        if (this.r749dfmt() != 2) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 2");
        }
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger r749dwumAsBigInteger() {
        if (this.r749dfmt() != 2) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 2");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long r749dbyx() {
        if (this.r749dfmt() != 3) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 3");
        }
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger r749dbyxAsBigInteger() {
        if (this.r749dfmt() != 3) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 3");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long r749swbf() {
        if (this.r749dfmt() != 4) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 4");
        }
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger r749swbfAsBigInteger() {
        if (this.r749dfmt() != 4) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 4");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long r749dbyt() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger r749dbytAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public int r749dfmt() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public long r749ssrf() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger r749ssrfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long r749dpkr() {
        if (this.r749dfmt() != 1) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 1");
        }
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger r749dpkrAsBigInteger() {
        if (this.r749dfmt() != 1) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 1");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long r749slrf() {
        if (this.r749dfmt() != 4) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 4");
        }
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger r749slrfAsBigInteger() {
        if (this.r749dfmt() != 4) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 4");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long r749dpkt() {
        if (this.r749dfmt() != 1) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 1");
        }
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger r749dpktAsBigInteger() {
        if (this.r749dfmt() != 1) {
            throw new NotAvailableException("This method is only supported when r749dfmt() == 1");
        }
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long r749srrf() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger r749srrfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public Duration r749stpf() {
        return Util.Binary8USSeconds(this.data, 48);
    }

    public double r749stpfSeconds() {
        return Util.ToSeconds(this.r749stpf());
    }

    public BigInteger r749stpfRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long r749srbc() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger r749srbcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long r749swbc() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger r749swbcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long r749ssrc() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger r749ssrcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long r749slrc() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger r749slrcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long r749srrc() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger r749srrcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public Duration r749stpc() {
        return Util.Binary8USSeconds(this.data, 96);
    }

    public double r749stpcSeconds() {
        return Util.ToSeconds(this.r749stpc());
    }

    public BigInteger r749stpcRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public static PcieDmaDataSection create(byte[] Data2, int offset, int length) {
        return new PcieDmaDataSection(Data2, offset, length);
    }

    static enum Field {
        r749dmar(0, 8),
        r749dwup(0, 8),
        r749srbf(0, 8),
        r749dbyr(0, 8),
        r749dmaw(8, 8),
        r749dwum(8, 8),
        r749dbyx(8, 8),
        r749swbf(8, 8),
        r749dbyt(8, 8),
        r749dfmt(16, 1),
        r749ssrf(24, 8),
        r749dpkr(24, 8),
        r749slrf(32, 8),
        r749dpkt(32, 8),
        r749srrf(40, 8),
        r749stpf(48, 8),
        r749srbc(56, 8),
        r749swbc(64, 8),
        r749ssrc(72, 8),
        r749slrc(80, 8),
        r749srrc(88, 8),
        r749stpc(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

