/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf77.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class EnqueueDataSection
extends SmfData {
    public static final int SMF77HLD = 128;
    public static final int SMF77SCP = 64;
    public static final int SMF77DOU = 32;
    public static final int SMF77D1E = 16;
    public static final int SMF77D2E = 8;
    public static final int SMF77GLB = 4;

    private EnqueueDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf77qnm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf77rnm() {
        return Util.ConvertEbcdic(this.data, 8, 44);
    }

    public Duration smf77wtm() {
        return Util.Binary4x1024MS(this.data, 52);
    }

    public double smf77wtmSeconds() {
        return Util.ToSeconds(this.smf77wtm());
    }

    public long smf77wtmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration smf77wtx() {
        return Util.Binary4x1024MS(this.data, 56);
    }

    public double smf77wtxSeconds() {
        return Util.ToSeconds(this.smf77wtx());
    }

    public long smf77wtxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public Duration smf77wtt() {
        return Util.Binary4x1024MS(this.data, 60);
    }

    public double smf77wttSeconds() {
        return Util.ToSeconds(this.smf77wtt());
    }

    public long smf77wttRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public int smf77rv3() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf77ql1() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf77ql2() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int smf77ql3() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public int smf77ql4() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf77qlt() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf77exm() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int smf77exx() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public int smf77shm() {
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf77shx() {
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf77evt() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public int smf77rln() {
        return Util.ConvertUnsignedBinary1(this.data, 86);
    }

    public int smf77dfg() {
        return Util.ConvertUnsignedBinary1(this.data, 87);
    }

    public boolean smf77hld() {
        return Util.ConvertFlag(this.data, this.smf77dfg(), 128);
    }

    public boolean smf77scp() {
        return Util.ConvertFlag(this.data, this.smf77dfg(), 64);
    }

    public boolean smf77dou() {
        return Util.ConvertFlag(this.data, this.smf77dfg(), 32);
    }

    public boolean smf77d1e() {
        return Util.ConvertFlag(this.data, this.smf77dfg(), 16);
    }

    public boolean smf77d2e() {
        return Util.ConvertFlag(this.data, this.smf77dfg(), 8);
    }

    public boolean smf77glb() {
        return Util.ConvertFlag(this.data, this.smf77dfg(), 4);
    }

    public int smf77dow() {
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public int smf77dwr() {
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public String smf77do1() {
        return Util.ConvertEbcdic(this.data, 92, 8);
    }

    public String smf77do2() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String smf77dw1() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public String smf77dw2() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public String smf77sy1() {
        return Util.ConvertEbcdic(this.data, 124, 8);
    }

    public String smf77sy2() {
        return Util.ConvertEbcdic(this.data, 132, 8);
    }

    public String smf77sy3() {
        return Util.ConvertEbcdic(this.data, 140, 8);
    }

    public String smf77sy4() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public long smf77aql() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long smf77csc() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long smf77nod() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public static EnqueueDataSection create(byte[] Data2, int offset, int length) {
        return new EnqueueDataSection(Data2, offset, length);
    }

    static enum Field {
        smf77qnm(0, 8),
        smf77rnm(8, 44),
        smf77wtm(52, 4),
        smf77wtx(56, 4),
        smf77wtt(60, 4),
        smf77rv3(64, 2),
        smf77ql1(66, 2),
        smf77ql2(68, 2),
        smf77ql3(70, 2),
        smf77ql4(72, 2),
        smf77qlt(74, 2),
        smf77exm(76, 2),
        smf77exx(78, 2),
        smf77shm(80, 2),
        smf77shx(82, 2),
        smf77evt(84, 2),
        smf77rln(86, 1),
        smf77dfg(87, 1),
        smf77dow(88, 2),
        smf77dwr(90, 2),
        smf77do1(92, 8),
        smf77do2(100, 8),
        smf77dw1(108, 8),
        smf77dw2(116, 8),
        smf77sy1(124, 8),
        smf77sy2(132, 8),
        smf77sy3(140, 8),
        smf77sy4(148, 8),
        smf77aql(156, 4),
        smf77csc(160, 4),
        smf77nod(164, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

