/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf78.subtype3;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf78.subtype3.IopInitiativeQueueAndUtilizationDataSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public final class IoControlSection
extends SmfData {
    private static final CreateSection<IopInitiativeQueueAndUtilizationDataSection> buildIopInitiativeQueueAndUtilizationDataSection = new CreateSection<IopInitiativeQueueAndUtilizationDataSection>(){

        @Override
        public IopInitiativeQueueAndUtilizationDataSection createSection(byte[] data, int offset, int length) {
            return IopInitiativeQueueAndUtilizationDataSection.create(data, offset, length);
        }
    };
    private List<IopInitiativeQueueAndUtilizationDataSection> m_iopInitiativeQueueAndUtilizationDataSections = null;
    public static final int R783GCMF = 128;
    public static final int R783GDIF = 64;
    public static final int R783GSPQ = 32;
    public static final int R783GCMH = 16;
    public static final int R783GCMD = 8;
    public static final int R783GIUD = 4;
    public static final int R783GCMR = 2;
    public static final int R783GTRD = 1;
    public static final int R783GAMG = 128;
    public static final int R783GECP = 64;
    public static final int R783GSCM = 32;
    public static final int R783DCA = 128;
    public static final int R783IAC = 64;
    public static final int R783IOD = 32;
    public static final int R783ICV = 16;
    public static final int R783MCS = 8;

    private IoControlSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public List<IopInitiativeQueueAndUtilizationDataSection> iopInitiativeQueueAndUtilizationDataSections() {
        this.m_iopInitiativeQueueAndUtilizationDataSections = Util.sectionsFromTriplet(this.m_iopInitiativeQueueAndUtilizationDataSections, this.data, Triplets.IopInitiativeQueueAndUtilizationDataSection.getTriplet(this), buildIopInitiativeQueueAndUtilizationDataSection);
        return this.m_iopInitiativeQueueAndUtilizationDataSections;
    }

    public int r783gflg() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean r783gcmf() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 128);
    }

    public boolean r783gdif() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 64);
    }

    public boolean r783gspq() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 32);
    }

    public boolean r783gcmh() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 16);
    }

    public boolean r783gcmd() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 8);
    }

    public boolean r783giud() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 4);
    }

    public boolean r783gcmr() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 2);
    }

    public boolean r783gtrd() {
        return Util.ConvertFlag(this.data, this.r783gflg(), 1);
    }

    public int r783gflx() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean r783gamg() {
        return Util.ConvertFlag(this.data, this.r783gflx(), 128);
    }

    public boolean r783gecp() {
        return Util.ConvertFlag(this.data, this.r783gflx(), 64);
    }

    public boolean r783gscm() {
        return Util.ConvertFlag(this.data, this.r783gflx(), 32);
    }

    public int r783gntr() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int r783gids() {
        return Util.ConvertSignedBinary4(this.data, 4);
    }

    public int r783gidl() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int r783gidn() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int r783tsr() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public long r783tot() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long r783nxt() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int r783cfl() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean r783dca() {
        return Util.ConvertFlag(this.data, this.r783cfl(), 128);
    }

    public boolean r783iac() {
        return Util.ConvertFlag(this.data, this.r783cfl(), 64);
    }

    public boolean r783iod() {
        return Util.ConvertFlag(this.data, this.r783cfl(), 32);
    }

    public boolean r783icv() {
        return Util.ConvertFlag(this.data, this.r783cfl(), 16);
    }

    public boolean r783mcs() {
        return Util.ConvertFlag(this.data, this.r783cfl(), 8);
    }

    public int r783css() {
        return Util.ConvertUnsignedBinary1(this.data, 29);
    }

    public String r783tnm() {
        return Util.ConvertEbcdic(this.data, 32, 44);
    }

    public String r783tsf() {
        return Util.ConvertEbcdic(this.data, 76, 2);
    }

    public String r783tok() {
        return Util.ConvertEbcdic(this.data, 80, 16);
    }

    public LocalDate r783tdt() {
        return Util.EBCDIC8mm_dd_yy(this.data, 80);
    }

    public String r783tdtRawValue() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public LocalTime r783ttm() {
        return Util.EBCDIC8hh_mm_ss(this.data, 88);
    }

    public String r783ttmRawValue() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public LocalDate r783tdy() {
        return Util.EBCDIC10mm_dd_yyyy(this.data, 96);
    }

    public String r783tdyRawValue() {
        return Util.ConvertEbcdic(this.data, 96, 10);
    }

    public static IoControlSection create(byte[] Data2, int offset, int length) {
        return new IoControlSection(Data2, offset, length);
    }

    private static enum Triplets {
        IopInitiativeQueueAndUtilizationDataSection{

            @Override
            Triplet getTriplet(IoControlSection controlsection) {
                return new Triplet(controlsection.r783gids(), controlsection.r783gidl(), controlsection.r783gidn());
            }
        };


        abstract Triplet getTriplet(IoControlSection var1);
    }

    static enum Field {
        r783gflg(0, 1),
        r783gflx(1, 1),
        r783gntr(2, 2),
        r783gids(4, 4),
        r783gidl(8, 2),
        r783gidn(10, 2),
        r783tsr(16, 2),
        r783tot(20, 4),
        r783nxt(24, 4),
        r783cfl(28, 1),
        r783css(29, 1),
        r783tnm(32, 44),
        r783tsf(76, 2),
        r783tok(80, 16),
        r783tdt(80, 8),
        r783ttm(88, 8),
        r783tdy(96, 10);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

