/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf88;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf88.EventsSection;
import com.blackhillsoftware.smf.smf88.LogstreamSection;
import com.blackhillsoftware.smf.smf88.ProductSection;
import com.blackhillsoftware.smf.smf88.StructureAlterSection;
import com.blackhillsoftware.smf.smf88.StructureInterimStorageSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public final class Smf88Record
extends SmfRecord {
    private List<ProductSection> m_ProductSection = null;
    private List<LogstreamSection> m_LogstreamSection = null;
    private List<EventsSection> m_EventsSection = null;
    private List<StructureInterimStorageSection> m_StructureInterimStorageSection = null;
    private List<StructureAlterSection> m_StructureAlterSection = null;

    public Smf88Record(byte[] data) {
        super(data);
        this.checkRecord();
    }

    public Smf88Record(SmfRecord record) {
        super(record);
        this.checkRecord();
    }

    public static Smf88Record from(SmfRecord record) {
        return new Smf88Record(record);
    }

    public static Smf88Record from(byte[] data) {
        return new Smf88Record(data);
    }

    private void checkRecord() {
        if (this.recordType() != 88) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public List<ProductSection> productSections() {
        this.m_ProductSection = Util.sectionsFromTriplet(this.m_ProductSection, this.data, () -> this.smf88pof(), () -> this.smf88pln(), () -> this.smf88pon(), ProductSection::create);
        return this.m_ProductSection;
    }

    public List<LogstreamSection> logstreamSections() {
        this.m_LogstreamSection = Util.sectionsFromTriplet(this.m_LogstreamSection, this.data, () -> this.smf88lof(), () -> this.smf88lln(), () -> this.smf88lon(), LogstreamSection::create);
        return this.m_LogstreamSection;
    }

    public List<EventsSection> eventsSections() {
        this.m_EventsSection = Util.sectionsFromTriplet(this.m_EventsSection, this.data, () -> this.smf88eof(), () -> this.smf88eln(), () -> this.smf88eon(), EventsSection::create);
        return this.m_EventsSection;
    }

    public List<StructureInterimStorageSection> structureInterimStorageSections() {
        this.m_StructureInterimStorageSection = Util.sectionsFromTriplet(this.m_StructureInterimStorageSection, this.data, () -> this.smf88sof(), () -> this.smf88sln(), () -> this.smf88son(), StructureInterimStorageSection::create);
        return this.m_StructureInterimStorageSection;
    }

    public List<StructureAlterSection> structureAlterSections() {
        this.m_StructureAlterSection = Util.sectionsFromTriplet(this.m_StructureAlterSection, this.data, () -> this.smf88aof(), () -> this.smf88aln(), () -> this.smf88aon(), StructureAlterSection::create);
        return this.m_StructureAlterSection;
    }

    public int smf88len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf88seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf88flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf88rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf88tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf88tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf88dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf88dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf88sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf88wid() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf88stp() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf88sdl() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf88pof() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf88pln() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf88pon() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf88lof() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf88lln() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf88lon() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf88eof() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf88eln() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf88eon() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf88sof() {
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf88sln() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf88son() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf88aof() {
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf88aln() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf88aon() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    static enum Field {
        smf88len(0, 2),
        smf88seg(2, 2),
        smf88flg(4, 1),
        smf88rty(5, 1),
        smf88tme(6, 4),
        smf88dte(10, 4),
        smf88sid(14, 4),
        smf88wid(18, 4),
        smf88stp(22, 2),
        smf88sdl(24, 4),
        smf88pof(28, 4),
        smf88pln(32, 2),
        smf88pon(34, 2),
        smf88lof(36, 4),
        smf88lln(40, 2),
        smf88lon(42, 2),
        smf88eof(44, 4),
        smf88eln(48, 2),
        smf88eon(50, 2),
        smf88sof(52, 4),
        smf88sln(56, 2),
        smf88son(58, 2),
        smf88aof(60, 4),
        smf88aln(64, 2),
        smf88aon(66, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

