/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf88;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class StructureAlterSection
extends SmfData {
    public static final int SMF88ABC = 128;
    public static final int SMF88ADC = 64;
    public static final int SMF88_BLOCKLEN_HIGH = Integer.MAX_VALUE;
    public static final int SMF88_BLOCKLEN_ZERO = 0;

    private StructureAlterSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf88anm() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public ZonedDateTime smf88atk() {
        return Util.Binary8xStckTime(this.data, 16);
    }

    public BigInteger smf88atkRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public BigInteger smf88ait() {
        return Util.ConvertBigInteger(this.data, 24, 8);
    }

    public long smf88awb() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf88awbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf88ao() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf88acb() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf88atb() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf88asz() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf88atw() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf88als() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public int smf88afg() {
        return Util.ConvertUnsignedBinary1(this.data, 64);
    }

    public boolean smf88abc() {
        return Util.ConvertFlag(this.data, this.smf88afg(), 128);
    }

    public boolean smf88adc() {
        return Util.ConvertFlag(this.data, this.smf88afg(), 64);
    }

    public static StructureAlterSection create(byte[] Data2, int offset, int length) {
        return new StructureAlterSection(Data2, offset, length);
    }

    static enum Field {
        smf88anm(0, 16),
        smf88atk(16, 8),
        smf88ait(24, 8),
        smf88awb(32, 8),
        smf88ao(40, 4),
        smf88acb(44, 4),
        smf88atb(48, 4),
        smf88asz(52, 4),
        smf88atw(56, 4),
        smf88als(60, 4),
        smf88afg(64, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

