/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf89;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.values.CapacityChangeReason;
import java.time.LocalDate;
import java.time.LocalTime;

public final class SystemIdSection
extends SmfData {
    public static final int SMF89LP1 = 240;
    public static final int SMF89LPV = 128;
    public static final int SMF89LPM = 64;
    public static final int SMF89LP2 = 15;
    public static final int SMF89LNV = 128;
    public static final int SMF89LCR = 64;
    public static final int SMF89_Event_Driven_Interval_Rec = 128;
    public static final int SMF89_Capacity_Data_err = 64;
    public static final int SMF89_PCD_Rsvd_Exists = 32;

    private SystemIdSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf89syn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public LocalTime smf89ust() {
        return Util.Binary4x100STime(this.data, 8);
    }

    public long smf89ustRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public LocalDate smf89usd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf89usdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public LocalTime smf89uet() {
        return Util.Binary4x100STime(this.data, 16);
    }

    public long smf89uetRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public LocalDate smf89ued() {
        return Util.SMFDate(this.data, 20);
    }

    public int smf89uedRawValue() {
        return Util.ConvertPacked4(this.data, 20);
    }

    public long smf89csu() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf89sru() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public int smf89cmn() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf89cvn() {
        return Util.ConvertUnsignedBinary1(this.data, 34);
    }

    public int smf89lpi() {
        return Util.ConvertUnsignedBinary1(this.data, 35);
    }

    public boolean smf89lpv() {
        return Util.ConvertFlag(this.data, this.smf89lpi(), 128);
    }

    public boolean smf89lpm() {
        return Util.ConvertFlag(this.data, this.smf89lpi(), 64);
    }

    public int smf89ser() {
        return Util.ConvertUnsignedBinary3(this.data, 36);
    }

    public int smf89lp3() {
        return Util.ConvertUnsignedBinary1(this.data, 39);
    }

    public long smf89rpp() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public String smf89spn() {
        return Util.ConvertEbcdic(this.data, 44, 8);
    }

    public String smf89cpt() {
        return Util.ConvertEbcdic(this.data, 52, 6);
    }

    public String smf89cpm() {
        return Util.ConvertEbcdic(this.data, 58, 3);
    }

    public String smf89cps() {
        return Util.ConvertEbcdic(this.data, 61, 12);
    }

    public int smf89sif() {
        return Util.ConvertUnsignedBinary1(this.data, 73);
    }

    public boolean smf89lnv() {
        return Util.ConvertFlag(this.data, this.smf89sif(), 128);
    }

    public boolean smf89lcr() {
        return Util.ConvertFlag(this.data, this.smf89sif(), 64);
    }

    public String smf89mnf() {
        return Util.ConvertEbcdic(this.data, 76, 16);
    }

    public String smf89tid() {
        return Util.ConvertEbcdic(this.data, 92, 4);
    }

    public String smf89mdl() {
        return Util.ConvertEbcdic(this.data, 96, 16);
    }

    public String smf89sqc() {
        return Util.ConvertEbcdic(this.data, 112, 16);
    }

    public String smf89pom() {
        return Util.ConvertEbcdic(this.data, 128, 4);
    }

    public long smf89cpc() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public int smf89ccc() {
        return Util.ConvertUnsignedBinary2(this.data, 136);
    }

    public int smf89scc() {
        return Util.ConvertUnsignedBinary2(this.data, 138);
    }

    public byte[] smf89maf() {
        if (this.data.length >= 170) {
            byte[] result = new byte[30];
            System.arraycopy(this.data, 140, result, 0, 30);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(140) + " Data length: " + Integer.toString(30));
    }

    public String smf89lpn() {
        return Util.ConvertEbcdic(this.data, 170, 8);
    }

    public int smf89CapacityChangeCnt() {
        return Util.ConvertUnsignedBinary2(this.data, 178);
    }

    public long smf89RctpcpuaActual() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long smf89RctpcpuaNominal() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long smf89RctpcpuaScalingFactor() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public int smf89CapacityAdjustmentInd() {
        return Util.ConvertUnsignedBinary1(this.data, 192);
    }

    public CapacityChangeReason smf89CapacityChangeRsn() {
        return CapacityChangeReason.from(Util.ConvertUnsignedBinary1(this.data, 193));
    }

    public int smf89CapacityChangeRsnRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 193);
    }

    public int smf89CapacityFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 194);
    }

    public boolean smf89EventDrivenIntervalRec() {
        return Util.ConvertFlag(this.data, this.smf89CapacityFlags(), 128);
    }

    public boolean smf89CapacityDataErr() {
        return Util.ConvertFlag(this.data, this.smf89CapacityFlags(), 64);
    }

    public boolean smf89PcdRsvdExists() {
        return Util.ConvertFlag(this.data, this.smf89CapacityFlags(), 32);
    }

    public long smf89znf() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long smf89snf() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public int smf89seq() {
        return Util.ConvertUnsignedBinary2(this.data, 204);
    }

    public String smf89solutionId() {
        return Util.ConvertEbcdic(this.data, 206, 64);
    }

    public static SystemIdSection create(byte[] Data2, int offset, int length) {
        return new SystemIdSection(Data2, offset, length);
    }

    static enum Field {
        smf89syn(0, 8),
        smf89ust(8, 4),
        smf89usd(12, 4),
        smf89uet(16, 4),
        smf89ued(20, 4),
        smf89csu(24, 4),
        smf89sru(28, 4),
        smf89cmn(32, 2),
        smf89cvn(34, 1),
        smf89lpi(35, 1),
        smf89ser(36, 3),
        smf89lp3(39, 1),
        smf89rpp(40, 4),
        smf89spn(44, 8),
        smf89cpt(52, 6),
        smf89cpm(58, 3),
        smf89cps(61, 12),
        smf89sif(73, 1),
        smf89mnf(76, 16),
        smf89tid(92, 4),
        smf89mdl(96, 16),
        smf89sqc(112, 16),
        smf89pom(128, 4),
        smf89cpc(132, 4),
        smf89ccc(136, 2),
        smf89scc(138, 2),
        smf89maf(140, 30),
        smf89lpn(170, 8),
        smf89CapacityChangeCnt(178, 2),
        smf89RctpcpuaActual(180, 4),
        smf89RctpcpuaNominal(184, 4),
        smf89RctpcpuaScalingFactor(188, 4),
        smf89CapacityAdjustmentInd(192, 1),
        smf89CapacityChangeRsn(193, 1),
        smf89CapacityFlags(194, 1),
        smf89znf(196, 4),
        smf89snf(200, 4),
        smf89seq(204, 2),
        smf89solutionId(206, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

