/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class ResetCommandSection
extends SmfData {
    public static final int SMF90T30_QUIESCE = 128;
    public static final int SMF90T30_RESUME = 64;
    public static final int SMF90T30_SRVCLASS = 32;
    public static final int SMF90T30_PGN = 16;
    public static final int SMF90T30_ENCLAVESRVCLASS = 8;
    public static final int SMF90T30_ENCLAVEQUIESCE = 4;
    public static final int SMF90T30_ENCLAVERESUME = 2;
    public static final int SMF90T30_INDEPENDENTENCLAVE = 128;

    private ResetCommandSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf90t30Jobname() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf90t30Jobid() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public LocalTime smf90t30EntryTime() {
        return Util.Binary4x100STime(this.data, 16);
    }

    public long smf90t30EntryTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public LocalDate smf90t30EntryDate() {
        return Util.SMFDate(this.data, 20);
    }

    public int smf90t30EntryDateRawValue() {
        return Util.ConvertPacked4(this.data, 20);
    }

    public String smf90t30Operator() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public int smf90t30Flags() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public boolean smf90t30Quiesce() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 128);
    }

    public boolean smf90t30Resume() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 64);
    }

    public boolean smf90t30Srvclass() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 32);
    }

    public boolean smf90t30Pgn() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 16);
    }

    public boolean smf90t30EnclaveSrvclass() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 8);
    }

    public boolean smf90t30EnclaveQuiesce() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 4);
    }

    public boolean smf90t30EnclaveResume() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags(), 2);
    }

    public int smf90t30Flags2() {
        return Util.ConvertUnsignedBinary1(this.data, 33);
    }

    public boolean smf90t30IndependentEnclave() {
        return Util.ConvertFlag(this.data, this.smf90t30Flags2(), 128);
    }

    public String smf90t30OldSrv() {
        return Util.ConvertEbcdic(this.data, 36, 8);
    }

    public String smf90t30NewSrv() {
        return Util.ConvertEbcdic(this.data, 44, 8);
    }

    public String smf90t30EnclaveOwner() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public static ResetCommandSection create(byte[] Data2, int offset, int length) {
        return new ResetCommandSection(Data2, offset, length);
    }

    static enum Field {
        smf90t30Jobname(0, 8),
        smf90t30Jobid(8, 8),
        smf90t30EntryTime(16, 4),
        smf90t30EntryDate(20, 4),
        smf90t30Operator(24, 8),
        smf90t30Flags(32, 1),
        smf90t30Flags2(33, 1),
        smf90t30OldSrv(36, 8),
        smf90t30NewSrv(44, 8),
        smf90t30EnclaveOwner(56, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

